/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.BundleContextDelegate;
import dev.equo.solstice.BundleContextShim;
import dev.equo.solstice.Capability;
import dev.equo.solstice.ShimBundleRevision;
import dev.equo.solstice.ShimBundleWiring;
import dev.equo.solstice.SolsticeManifest;
import dev.equo.solstice.Unchecked;
import dev.equo.solstice.Unimplemented;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.PackageAdmin;

public class ShimBundle
implements Bundle {
    final long bundleId;
    final SolsticeManifest manifest;
    @Nullable
    final String activator;
    final Hashtable<String, String> headers = new Hashtable();
    private final ShimBundleContext context;
    int state;
    private boolean activateHasBeenCalled = false;

    ShimBundle(long bundleId, BundleContextShim context, SolsticeManifest manifest) {
        this.bundleId = bundleId;
        this.context = new ShimBundleContext(context, this);
        this.manifest = manifest;
        this.activator = manifest.getHeadersOriginal().get("Bundle-Activator");
        manifest.getHeadersOriginal().forEach((key, value) -> {
            if (!"Import-Package".equals(key) && !"Export-Package".equals(key)) {
                this.headers.put((String)key, (String)value);
            }
        });
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    BundleContextShim getRootBundleContext() {
        return this.context.delegate;
    }

    public String toString() {
        return this.manifest.toString();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public Version getVersion() {
        return this.manifest.getVersion();
    }

    public void start(int options) {
        this.start();
    }

    public void start() {
        this.activate();
    }

    public void stop(int options) {
        this.stop();
    }

    private void activate() {
        if (this.activateHasBeenCalled) {
            return;
        }
        this.activateHasBeenCalled = true;
        if (this.state != 4) {
            this.state = 4;
            this.context.delegate.notifyBundleListeners(32, this);
        }
        for (Capability cap : this.manifest.capProvides) {
            this.context.delegate.capabilities.put(cap, this);
        }
        this.state = 8;
        this.context.delegate.notifyBundleListeners(128, this);
        if (!BundleContextShim.DONT_ACTIVATE.contains(this.getSymbolicName()) && this.activator != null) {
            try {
                Constructor<?> c = Class.forName(this.activator).getConstructor(new Class[0]);
                this.context.activator = (BundleActivator)c.newInstance(new Object[0]);
                this.context.activator.start((BundleContext)this.context);
            }
            catch (Exception e) {
                this.context.delegate.logger.warn("Error in activator of " + this.getSymbolicName(), (Throwable)e);
            }
            for (SolsticeManifest fragment : this.manifest.fragments) {
                try {
                    String extensionActivator = fragment.getHeadersOriginal().get("ExtensionBundle-Activator");
                    if (extensionActivator == null) continue;
                    Constructor<?> c = Class.forName(extensionActivator).getConstructor(new Class[0]);
                    ((BundleActivator)c.newInstance(new Object[0])).start((BundleContext)this.context);
                }
                catch (Exception e) {
                    this.context.delegate.logger.warn("Error in fragment activator of " + fragment.getSymbolicName(), (Throwable)e);
                }
            }
        }
        this.state = 32;
        this.context.delegate.notifyBundleListeners(2, this);
    }

    public int getState() {
        return this.state;
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders("");
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.headers;
    }

    public String getSymbolicName() {
        return this.manifest.getSymbolicName();
    }

    private static String stripLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private static String stripLeadingAddTrailingSlash(String path) {
        if ((path = ShimBundle.stripLeadingSlash(path)).isEmpty() || path.equals("/")) {
            return "";
        }
        return path.endsWith("/") ? path : path + "/";
    }

    public URL getEntry(String path) {
        try {
            if (path.equals("/")) {
                if (!this.manifest.getJarUrl().startsWith("jar:file:") || !this.manifest.getJarUrl().endsWith("!")) {
                    throw new IllegalArgumentException("Expected jarUrl to start with `jar:` and end with `!`, was `" + this.manifest.getJarUrl() + "`");
                }
                int len = this.manifest.getJarUrl().length();
                return new URL(this.manifest.getJarUrl().substring("jar:".length(), len - "!".length()));
            }
            ZipEntry entry = this.parseFromZip(zip -> zip.getEntry(ShimBundle.stripLeadingSlash(path)));
            if (entry != null) {
                return new URL(this.manifest.getJarUrl() + "/" + ShimBundle.stripLeadingSlash(path));
            }
            return null;
        }
        catch (MalformedURLException e) {
            throw Unchecked.wrap(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T parseFromZip(Function<ZipFile, T> function) {
        String prefix = "jar:file:";
        if (!this.manifest.getJarUrl().startsWith(prefix)) {
            throw new IllegalArgumentException("Must start with " + prefix + " was " + this.manifest.getJarUrl());
        }
        if (!this.manifest.getJarUrl().endsWith("!")) {
            throw new IllegalArgumentException("Must end with ! was " + this.manifest.getJarUrl());
        }
        try (ZipFile zipFile = new ZipFile(this.manifest.getJarUrl().substring(prefix.length(), this.manifest.getJarUrl().length() - 1));){
            ZipFile t = function.apply(zipFile);
            return (T)t;
        }
        catch (IOException e) {
            throw Unchecked.wrap(e);
        }
    }

    public URL getResource(String name) {
        ZipEntry entry = this.parseFromZip(zip -> zip.getEntry(ShimBundle.stripLeadingSlash(name)));
        if (entry != null) {
            return this.getEntry(name);
        }
        return BundleContextShim.class.getClassLoader().getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return BundleContextShim.class.getClassLoader().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        String pathFinal = ShimBundle.stripLeadingAddTrailingSlash(path);
        return this.parseFromZip(zipFile -> {
            ArrayList<String> zipPaths = new ArrayList<String>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(pathFinal)) continue;
                zipPaths.add(entry.getName());
            }
            return Collections.enumeration(zipPaths);
        });
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Finder finder = new Finder(path, filePattern, recurse);
        finder.addEntriesIn(urls, this);
        return Collections.enumeration(urls);
    }

    public String getLocation() {
        return this.manifest.getJarUrl();
    }

    public File getDataFile(String filename) {
        return this.context.delegate.storage.getDataFileBundle(this, filename);
    }

    public <A> A adapt(Class<A> type) {
        if (this.bundleId == 0L) {
            if (type.equals(PackageAdmin.class)) {
                return (A)this.context.delegate.packageAdmin;
            }
            if (type.equals(FrameworkWiring.class)) {
                return (A)this.context.delegate.frameworkWiring;
            }
            if (type.equals(BundleRevision.class)) {
                return null;
            }
            if (type.equals(FrameworkStartLevel.class)) {
                return (A)new Unimplemented.FrameworkStartLevel(){};
            }
            throw new UnsupportedOperationException(type.getName());
        }
        if (BundleWiring.class.equals(type)) {
            return (A)(this.state == 2 ? null : new ShimBundleWiring(this));
        }
        if (BundleStartLevel.class.equals(type)) {
            return (A)new Unimplemented.BundleStartLevel(){

                @Override
                public boolean isActivationPolicyUsed() {
                    return true;
                }

                @Override
                public void setStartLevel(int startlevel) {
                }
            };
        }
        if (BundleRevision.class.equals(type)) {
            return (A)new ShimBundleRevision(this);
        }
        return null;
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw Unimplemented.onPurpose();
    }

    public ServiceReference<?>[] getRegisteredServices() {
        throw Unimplemented.onPurpose();
    }

    public ServiceReference<?>[] getServicesInUse() {
        throw Unimplemented.onPurpose();
    }

    public boolean hasPermission(Object permission) {
        throw Unimplemented.onPurpose();
    }

    public void stop() {
        throw Unimplemented.onPurpose();
    }

    public void update(InputStream input) {
        throw Unimplemented.onPurpose();
    }

    public void update() {
        throw Unimplemented.onPurpose();
    }

    public void uninstall() {
        throw Unimplemented.onPurpose();
    }

    public long getLastModified() {
        throw Unimplemented.onPurpose();
    }

    public int compareTo(@NotNull Bundle o) {
        throw Unimplemented.onPurpose();
    }

    static class Finder {
        final String pathFinal;
        final Pattern pattern;
        final boolean recurse;

        Finder(String path, String filePattern, boolean recurse) {
            this.pathFinal = ShimBundle.stripLeadingAddTrailingSlash(path);
            this.pattern = Pattern.compile(filePattern.replace(".", "\\.").replace("$", "\\$").replace("*", ".*"));
            this.recurse = recurse;
        }

        void addEntriesIn(List<URL> urls, ShimBundle bundle) {
            for (SolsticeManifest solsticeManifest : bundle.manifest.fragments) {
                this.addEntriesIn(urls, (ShimBundle)solsticeManifest.hydrated);
            }
            List pathsWithinZip = bundle.parseFromZip(zipFile -> {
                ArrayList<String> zipPaths = new ArrayList<String>();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String name;
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(this.pathFinal)) continue;
                    String after = entry.getName().substring(this.pathFinal.length());
                    int lastSlash = after.lastIndexOf(47);
                    if (lastSlash == -1) {
                        if (!this.pattern.matcher(after).matches()) continue;
                        zipPaths.add(entry.getName());
                        continue;
                    }
                    if (!this.recurse || !this.pattern.matcher(name = after.substring(lastSlash + 1)).matches()) continue;
                    zipPaths.add(entry.getName());
                }
                return zipPaths;
            });
            try {
                for (String withinZip : pathsWithinZip) {
                    urls.add(new URL(bundle.manifest.getJarUrl() + "/" + withinZip));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw Unchecked.wrap(malformedURLException);
            }
        }
    }

    static class ShimBundleContext
    extends BundleContextDelegate {
        final ShimBundle bundle;
        BundleActivator activator;

        ShimBundleContext(BundleContextShim rootContext, ShimBundle bundle) {
            super(rootContext);
            this.bundle = bundle;
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

