/*
 * Decompiled with CFR 0.152.
 */
package dev.nx.gradle;

import com.google.gson.Gson;
import dev.nx.gradle.data.GradleNodeReport;
import dev.nx.gradle.utils.ProjectUtilsKt;
import java.io.File;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0019\u001a\u00020\u001a8G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Ldev/nx/gradle/NxProjectReportTask;", "Lorg/gradle/api/DefaultTask;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "<init>", "(Lorg/gradle/api/file/ProjectLayout;)V", "projectName", "Lorg/gradle/api/provider/Property;", "", "getProjectName", "()Lorg/gradle/api/provider/Property;", "hash", "getHash", "workspaceRoot", "getWorkspaceRoot", "atomized", "", "getAtomized", "targetNameOverrides", "Lorg/gradle/api/provider/MapProperty;", "getTargetNameOverrides", "()Lorg/gradle/api/provider/MapProperty;", "projectRef", "Lorg/gradle/api/Project;", "getProjectRef", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "action", "", "Companion", "project-graph"})
public abstract class NxProjectReportTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectLayout projectLayout;
    @NotNull
    private static final Gson gson = new Gson();

    @Inject
    public NxProjectReportTask(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.projectLayout = projectLayout;
        this.getAtomized().convention((Object)true);
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectName();

    @Input
    @NotNull
    public abstract Property<String> getHash();

    @Input
    @NotNull
    public abstract Property<String> getWorkspaceRoot();

    @Input
    @NotNull
    public abstract Property<Boolean> getAtomized();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getTargetNameOverrides();

    @Internal
    @NotNull
    public abstract Property<Project> getProjectRef();

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = ((RegularFile)this.projectLayout.getBuildDirectory().file("nx/" + this.getProjectName().get() + ".json").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        return file;
    }

    @TaskAction
    public final void action() {
        this.getLogger().info(new Date() + " Apply task action NxProjectReportTask for " + this.getProjectName().get());
        this.getLogger().info(new Date() + " Hash input: " + this.getHash().get());
        this.getLogger().info(new Date() + " Target Name Overrides " + this.getTargetNameOverrides().get());
        this.getLogger().info(new Date() + " Atomized: " + this.getAtomized().get());
        Project project = (Project)this.getProjectRef().get();
        Intrinsics.checkNotNull((Object)project);
        Object object = this.getTargetNameOverrides().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map map = (Map)object;
        Object object2 = this.getWorkspaceRoot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String string = (String)object2;
        Object object3 = this.getAtomized().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        GradleNodeReport report = ProjectUtilsKt.createNodeForProject(project, map, string, (Boolean)object3);
        String reportJson = gson.toJson((Object)report);
        if (this.getOutputFile().exists() && Intrinsics.areEqual((Object)FilesKt.readText$default((File)this.getOutputFile(), null, (int)1, null), (Object)reportJson)) {
            this.getLogger().info(new Date() + " No change in the node report for " + this.getProjectName().get());
            return;
        }
        this.getLogger().info(new Date() + " Writing node report for " + this.getProjectName().get());
        File file = this.getOutputFile();
        Intrinsics.checkNotNull((Object)reportJson);
        FilesKt.writeText$default((File)file, (String)reportJson, null, (int)2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/nx/gradle/NxProjectReportTask$Companion;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "project-graph"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

