/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;

public abstract class FlexibleViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    protected final FlexibleAdapter mAdapter;
    protected final OnListItemClickListener mListItemClickListener;

    public FlexibleViewHolder(View view, FlexibleAdapter adapter, OnListItemClickListener listItemClickListener) {
        super(view);
        this.mAdapter = adapter;
        this.mListItemClickListener = listItemClickListener;
        this.itemView.setOnClickListener((View.OnClickListener)this);
        this.itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    public void onClick(View view) {
        if (this.mListItemClickListener != null && this.mListItemClickListener.onListItemClick(this.getAdapterPosition())) {
            this.toggleActivation();
        }
    }

    public boolean onLongClick(View view) {
        if (this.mListItemClickListener != null) {
            this.mListItemClickListener.onListItemLongClick(this.getAdapterPosition());
            this.toggleActivation();
            return true;
        }
        return false;
    }

    protected void toggleActivation() {
        this.itemView.setActivated(this.mAdapter.isSelected(this.getAdapterPosition()));
    }

    public static interface OnListItemClickListener {
        public boolean onListItemClick(int var1);

        public void onListItemLongClick(int var1);
    }
}

