/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SelectableAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    protected static boolean DEBUG = false;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_MULTI = 2;
    private ArrayList<Integer> selectedItems = new ArrayList();
    private int mode = 1;

    public static void enableLogs(boolean enable) {
        DEBUG = enable;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isSelected(int position) {
        return this.selectedItems.contains(position);
    }

    public void toggleSelection(int position) {
        this.toggleSelection(position, false);
    }

    public void toggleSelection(int position, boolean invalidate) {
        int index;
        if (position < 0) {
            return;
        }
        if (this.mode == 1) {
            this.clearSelection();
        }
        if ((index = this.selectedItems.indexOf(position)) != -1) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("toggleSelection removing selection on position " + position));
            }
            this.selectedItems.remove(index);
        } else {
            if (DEBUG) {
                Log.v((String)TAG, (String)("toggleSelection adding selection on position " + position));
            }
            this.selectedItems.add(position);
        }
        if (invalidate) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("toggleSelection notifyItemChanged on position " + position));
            }
            this.notifyItemChanged(position);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("toggleSelection current selection " + this.selectedItems));
        }
    }

    public void selectAll() {
        this.selectAll(-1);
    }

    public void selectAll(int skipViewType) {
        if (DEBUG) {
            Log.v((String)TAG, (String)"selectAll");
        }
        this.selectedItems = new ArrayList(this.getItemCount());
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getItemViewType(i) == skipViewType) continue;
            this.selectedItems.add(i);
            if (DEBUG) {
                Log.v((String)TAG, (String)("selectAll notifyItemChanged on position " + i));
            }
            this.notifyItemChanged(i);
        }
    }

    public void clearSelection() {
        Iterator<Integer> iterator = this.selectedItems.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            iterator.remove();
            if (DEBUG) {
                Log.v((String)TAG, (String)("clearSelection notifyItemChanged on position " + i));
            }
            this.notifyItemChanged(i);
        }
    }

    public int getSelectedItemCount() {
        return this.selectedItems.size();
    }

    public List<Integer> getSelectedItems() {
        return this.selectedItems;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putIntegerArrayList(TAG, this.selectedItems);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        this.selectedItems = savedInstanceState.getIntegerArrayList(TAG);
    }
}

