/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.FlexibleAnimatorAdapter;
import eu.davidea.flexibleadapter.R;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.flexibleadapter.helpers.StickyHeaderHelper;
import eu.davidea.flexibleadapter.items.IExpandable;
import eu.davidea.flexibleadapter.items.IFilterable;
import eu.davidea.flexibleadapter.items.IFlexible;
import eu.davidea.flexibleadapter.items.IHeader;
import eu.davidea.flexibleadapter.items.ISectionable;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FlexibleAdapter<T extends IFlexible>
extends FlexibleAnimatorAdapter
implements ItemTouchHelperCallback.AdapterCallback {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    private static final String EXTRA_PARENT = TAG + "_parentSelected";
    private static final String EXTRA_CHILD = TAG + "_childSelected";
    private static final String EXTRA_HEADERS = TAG + "_headersShown";
    public static final int EXPANDABLE_VIEW_TYPE = -1;
    public static final int SECTION_VIEW_TYPE = -2;
    public static final long UNDO_TIMEOUT = 5000L;
    private List<T> mItems;
    private List<IHeader> mOrphanHeaders;
    private boolean headersShown = false;
    private boolean headersSticky = false;
    private boolean recursive = false;
    private StickyHeaderHelper mStickyHeaderHelper;
    protected Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    FlexibleAdapter.this.filterItems((List)message.obj);
                    return true;
                }
                case 1: {
                    OnDeleteCompleteListener listener = (OnDeleteCompleteListener)message.obj;
                    if (listener != null) {
                        listener.onDeleteConfirmed();
                    }
                    FlexibleAdapter.this.emptyBin();
                    return true;
                }
            }
            return false;
        }
    });
    private List<RestoreInfo> mRestoreList;
    private boolean restoreSelection = false;
    private boolean multiRange = false;
    private boolean unlinkOnRemoveHeader = true;
    private boolean removeOrphanHeaders = false;
    private boolean permanentDelete = false;
    private boolean adjustSelected = true;
    protected LayoutInflater mInflater;
    @SuppressLint(value={"UseSparseArrays"})
    private HashMap<Integer, T> mTypeInstances = new HashMap();
    private boolean autoMap = false;
    private String mSearchText = "";
    private String mOldSearchText = "";
    private boolean mNotifyChangeOfUnfilteredItems = false;
    private boolean filtering = false;
    private boolean scrollOnExpand = false;
    private boolean collapseOnExpand = false;
    private boolean childSelected = false;
    private boolean parentSelected = false;
    private boolean longPressDragEnabled = false;
    private boolean handleDragEnabled = true;
    private boolean swipeEnabled = false;
    private ItemTouchHelperCallback mItemTouchHelperCallback;
    private ItemTouchHelper mItemTouchHelper;
    protected OnUpdateListener mUpdateListener;
    public OnItemClickListener mItemClickListener;
    public OnItemLongClickListener mItemLongClickListener;
    protected OnItemMoveListener mItemMoveListener;
    protected OnItemSwipeListener mItemSwipeListener;
    protected OnStickyHeaderChangeListener mStickyHeaderChangeListener;

    public FlexibleAdapter(@NonNull List<T> items) {
        this(items, null);
    }

    public FlexibleAdapter(@NonNull List<T> items, @Nullable Object listeners) {
        this.mItems = Collections.synchronizedList(items);
        this.mRestoreList = new ArrayList<RestoreInfo>();
        this.mOrphanHeaders = new ArrayList<IHeader>();
        this.initializeItems();
        if (listeners instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listeners;
            this.mUpdateListener.onUpdateEmptyView(this.mItems.size());
        }
        if (listeners instanceof OnItemClickListener) {
            this.mItemClickListener = (OnItemClickListener)listeners;
        }
        if (listeners instanceof OnItemLongClickListener) {
            this.mItemLongClickListener = (OnItemLongClickListener)listeners;
        }
        if (listeners instanceof OnItemMoveListener) {
            this.mItemMoveListener = (OnItemMoveListener)listeners;
        }
        if (listeners instanceof OnItemSwipeListener) {
            this.mItemSwipeListener = (OnItemSwipeListener)listeners;
        }
        if (listeners instanceof OnStickyHeaderChangeListener) {
            this.mStickyHeaderChangeListener = (OnStickyHeaderChangeListener)listeners;
        }
        this.registerAdapterDataObserver(new AdapterDataObserver());
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.mStickyHeaderHelper != null && this.headersShown) {
            this.mStickyHeaderHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    @Override
    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mStickyHeaderHelper != null) {
            this.mStickyHeaderHelper.detachFromRecyclerView(this.mRecyclerView);
            this.mStickyHeaderHelper = null;
        }
        super.onDetachedFromRecyclerView(recyclerView);
    }

    protected void initializeItems() {
        this.setInitialize(true);
        this.multiRange = true;
        for (int position = 0; position < this.mItems.size(); ++position) {
            T item = this.getItem(position);
            if (!this.isExpandable(item)) continue;
            IExpandable expandable = (IExpandable)item;
            if (expandable.isExpanded()) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Initially expand item on position " + position));
                }
                position += this.addAllSubItemsFrom(position, expandable, false, null);
            }
            if (this.headersShown || !this.isHeader(item) || item.isHidden()) continue;
            this.headersShown = true;
        }
        this.multiRange = false;
        this.setInitialize(false);
    }

    public boolean isEnabled(int position) {
        T item = this.getItem(position);
        return item != null && item.isEnabled();
    }

    @Override
    public boolean isSelectable(int position) {
        return this.getItem(position).isSelectable();
    }

    @Override
    public void toggleSelection(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (item != null && item.isSelectable()) {
            boolean hasParent;
            boolean bl = hasParent = this.getExpandableOf(item) != null;
            if (!(!this.isExpandable(item) && hasParent || this.childSelected)) {
                this.parentSelected = true;
                super.toggleSelection(position);
            } else if (!this.parentSelected && hasParent) {
                this.childSelected = true;
                super.toggleSelection(position);
            }
        }
        if (this.getSelectedItemCount() == 0) {
            this.childSelected = false;
            this.parentSelected = false;
        }
    }

    @Override
    public void selectAll(Integer ... viewTypes) {
        if (this.getSelectedItemCount() > 0 && viewTypes.length == 0) {
            super.selectAll(this.getItemViewType(this.getSelectedPositions().get(0)));
        } else {
            super.selectAll(viewTypes);
        }
    }

    @Override
    @CallSuper
    public void clearSelection() {
        this.childSelected = false;
        this.parentSelected = false;
        super.clearSelection();
    }

    public boolean isAnyParentSelected() {
        return this.parentSelected;
    }

    public boolean isAnyChildSelected() {
        return this.childSelected;
    }

    public void updateDataSet(List<T> items) {
        this.animateTo(items);
        this.initializeItems();
        this.showAllHeaders();
    }

    public final T getItem(@IntRange(from=0L) int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return (T)((IFlexible)this.mItems.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public final int getItemCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    public int getItemCountOfTypes(Integer ... viewTypes) {
        return this.getItemCountOfTypesUntil(this.getItemCount(), viewTypes);
    }

    public int getItemCountOfTypesUntil(@IntRange(from=0L) int position, Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        int count = 0;
        for (int i = 0; i < position; ++i) {
            if ((!this.autoMap || !viewTypeList.contains(((IFlexible)this.mItems.get(i)).getLayoutRes())) && !viewTypeList.contains(this.getItemViewType(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public int getGlobalPositionOf(@NonNull IFlexible item) {
        return item != null && this.mItems != null && !this.mItems.isEmpty() ? this.mItems.indexOf(item) : -1;
    }

    public boolean contains(@NonNull T item) {
        return item != null && this.mItems != null && this.mItems.contains(item);
    }

    public boolean areHeadersShown() {
        return this.headersShown;
    }

    public FlexibleAdapter setDisplayHeadersAtStartUp(boolean displayHeaders) {
        this.setInitialize(true);
        this.headersShown = displayHeaders;
        if (displayHeaders) {
            this.showAllHeaders();
        }
        this.setInitialize(false);
        return this;
    }

    public boolean isRemoveOrphanHeaders() {
        return this.removeOrphanHeaders;
    }

    public FlexibleAdapter setRemoveOrphanHeaders(boolean removeOrphanHeaders) {
        this.removeOrphanHeaders = removeOrphanHeaders;
        return this;
    }

    public FlexibleAdapter setUnlinkAllItemsOnRemoveHeaders(boolean unlinkOnRemoveHeader) {
        this.unlinkOnRemoveHeader = unlinkOnRemoveHeader;
        return this;
    }

    public List<IHeader> getOrphanHeaders() {
        return this.mOrphanHeaders;
    }

    public FlexibleAdapter linkHeaderTo(@NonNull T item, @NonNull IHeader header) {
        this.linkHeaderTo(item, header, null);
        if (header.isHidden() && this.headersShown) {
            this.showHeaderOf(this.getGlobalPositionOf((IFlexible)item), item);
        }
        return this;
    }

    public IHeader unlinkHeaderFrom(@NonNull T item) {
        IHeader header = this.unlinkHeaderFrom(item, null);
        if (header != null && !header.isHidden()) {
            this.hideHeaderOf(item);
        }
        return header;
    }

    public List<IHeader> getHeaderItems() {
        ArrayList<IHeader> headers = new ArrayList<IHeader>();
        for (IFlexible item : this.mItems) {
            IHeader header = this.getHeaderOf(item);
            if (header == null) continue;
            headers.add(header);
        }
        return headers;
    }

    public boolean isHeader(@NonNull T item) {
        return item != null && item instanceof IHeader;
    }

    public boolean areHeadersSticky() {
        return this.headersSticky;
    }

    @Deprecated
    public void enableStickyHeaders(int maxCachedHeaders) {
        this.setStickyHeaders(true);
    }

    public void enableStickyHeaders() {
        this.setStickyHeaders(true);
    }

    public void disableStickyHeaders() {
        this.setStickyHeaders(false);
    }

    private void setStickyHeaders(boolean headersSticky) {
        if (this.headersShown && headersSticky) {
            this.headersSticky = true;
            if (this.mStickyHeaderHelper == null) {
                this.mStickyHeaderHelper = new StickyHeaderHelper(this, this.mStickyHeaderChangeListener);
            }
            if (!this.mStickyHeaderHelper.isAttachedToRecyclerView()) {
                this.mStickyHeaderHelper.attachToRecyclerView(this.mRecyclerView);
            }
        } else if (this.mStickyHeaderHelper != null) {
            this.headersSticky = false;
            this.mStickyHeaderHelper.detachFromRecyclerView(this.mRecyclerView);
            this.mStickyHeaderHelper = null;
        }
    }

    public ViewGroup getStickySectionHeadersHolder() {
        return (ViewGroup)((Activity)this.mRecyclerView.getContext()).findViewById(R.id.sticky_header_container);
    }

    public boolean hasHeader(@NonNull T item) {
        return this.getHeaderOf(item) != null;
    }

    public boolean hasSameHeader(@NonNull T item, @NonNull IHeader header) {
        IHeader current = this.getHeaderOf(item);
        return current != null && header != null && current.equals(header);
    }

    public IHeader getHeaderOf(@NonNull T item) {
        if (item != null && item instanceof ISectionable) {
            return ((ISectionable)item).getHeader();
        }
        return null;
    }

    public IHeader getSectionHeader(@IntRange(from=0L) int position) {
        if (!this.headersShown || !this.headersSticky) {
            return null;
        }
        for (int i = position; i >= 0; --i) {
            T item = this.getItem(i);
            if (this.isHeader(item)) {
                return (IHeader)item;
            }
            IHeader header = this.getHeaderOf(item);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    public int getSectionIndex(@NonNull IHeader header) {
        int position = this.getGlobalPositionOf(header);
        return this.getSectionIndex(position);
    }

    public int getSectionIndex(@IntRange(from=0L) int position) {
        int sectionIndex = 0;
        for (int i = 0; i <= position; ++i) {
            if (!this.isHeader(this.getItem(i))) continue;
            ++sectionIndex;
        }
        return sectionIndex;
    }

    public ISectionable getSectionableOf(@NonNull IHeader header) {
        int headerPosition = this.getGlobalPositionOf(header);
        for (int position = headerPosition - 1; position <= headerPosition + 2; ++position) {
            IHeader realHeader = this.getHeaderOf(this.getItem(position));
            if (realHeader == null || !realHeader.equals(header)) continue;
            return (ISectionable)this.getItem(position);
        }
        return null;
    }

    public List<ISectionable> getSectionItems(@NonNull IHeader header) {
        ISectionable sectionable;
        ArrayList<ISectionable> sectionItems = new ArrayList<ISectionable>();
        do {
            if ((sectionable = this.getSectionableOf(header)) == null) continue;
            sectionItems.add(sectionable);
        } while (sectionable != null);
        return sectionItems;
    }

    public void showAllHeaders() {
        this.multiRange = true;
        this.resetHiddenStatus();
        for (int position = 0; position < this.mItems.size(); ++position) {
            if (!this.showHeaderOf(position, (IFlexible)this.mItems.get(position))) continue;
            ++position;
        }
        this.headersShown = true;
        this.multiRange = false;
    }

    public void hideAllHeaders() {
        this.multiRange = true;
        for (IHeader header : this.getOrphanHeaders()) {
            this.hideHeader(this.getGlobalPositionOf(header), header);
        }
        for (int position = this.mItems.size() - 1; position >= 0; --position) {
            if (!this.hideHeaderOf((IFlexible)this.mItems.get(position))) continue;
            --position;
        }
        this.headersShown = false;
        this.setStickyHeaders(false);
        this.multiRange = false;
    }

    private void resetHiddenStatus() {
        for (IFlexible item : this.mItems) {
            IHeader header = this.getHeaderOf(item);
            if (header == null || this.isExpandable(header)) continue;
            header.setHidden(true);
        }
    }

    private boolean showHeaderOf(int position, @NonNull T item) {
        IHeader header = this.getHeaderOf(item);
        if (header == null || this.getPendingRemovedItem(item) != null) {
            return false;
        }
        if (header.isHidden()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Showing header at position " + position + "=" + header));
            }
            header.setHidden(false);
            return this.addItem(position, header);
        }
        return false;
    }

    private boolean hideHeaderOf(@NonNull T item) {
        IHeader header = this.getHeaderOf(item);
        return header != null && !header.isHidden() && this.hideHeader(this.getGlobalPositionOf(header), header);
    }

    private boolean hideHeader(int position, IHeader header) {
        if (position >= 0) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Hiding header at position " + position + "=" + header));
            }
            header.setHidden(true);
            this.mItems.remove(position);
            this.notifyItemRemoved(position);
            return true;
        }
        return false;
    }

    private boolean linkHeaderTo(@NonNull T item, @NonNull IHeader header, @Nullable Object payload) {
        boolean linked = false;
        if (item != null && item instanceof ISectionable) {
            ISectionable sectionable = (ISectionable)item;
            this.unlinkHeaderFrom(sectionable, payload);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Link header " + header + " to " + sectionable));
            }
            sectionable.setHeader(header);
            linked = true;
            this.removeFromOrphanList(header);
        } else {
            this.addToOrphanListIfNeeded(header, 0, this.getItemCount());
        }
        this.notifyItemChanged(this.getGlobalPositionOf(header), payload);
        return linked;
    }

    private IHeader unlinkHeaderFrom(@NonNull T item, @Nullable Object payload) {
        if (this.hasHeader(item)) {
            ISectionable sectionable = (ISectionable)item;
            Object header = sectionable.getHeader();
            if (DEBUG) {
                Log.v((String)TAG, (String)("Unlink header " + header + " from " + sectionable));
            }
            sectionable.setHeader(null);
            if (!header.isHidden()) {
                this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)header), payload);
            }
            this.addToOrphanListIfNeeded((IHeader)header, 0, this.getItemCount());
            return header;
        }
        return null;
    }

    private void addToOrphanListIfNeeded(IHeader header, int positionStart, int itemCount) {
        if (!this.mOrphanHeaders.contains(header) && !this.isHeaderShared(header, positionStart, itemCount)) {
            this.mOrphanHeaders.add(header);
            if (DEBUG) {
                Log.d((String)TAG, (String)("Added to orphan list [" + this.mOrphanHeaders.size() + "] Header " + header));
            }
        }
    }

    private void removeFromOrphanList(IHeader header) {
        if (this.mOrphanHeaders.remove(header) && DEBUG) {
            Log.d((String)TAG, (String)("Removed from orphan list [" + this.mOrphanHeaders.size() + "] Header " + header));
        }
    }

    private boolean isHeaderShared(IHeader header, int positionStart, int itemCount) {
        int firstElementWithHeader;
        T item;
        for (int i = firstElementWithHeader = this.getGlobalPositionOf(header) + 1; i < this.mItems.size() && !((item = this.getItem(i)) instanceof IHeader); ++i) {
            if (i >= positionStart && i < positionStart + itemCount || !this.hasSameHeader(item, header)) continue;
            return true;
        }
        return false;
    }

    public int getItemViewType(int position) {
        T item = this.getItem(position);
        assert (item != null);
        this.mapViewTypeFrom(item);
        this.autoMap = true;
        return item.getLayoutRes();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        T item;
        if (this.mInflater == null) {
            this.mInflater = LayoutInflater.from((Context)parent.getContext());
        }
        if ((item = this.getViewTypeInstance(viewType)) == null) {
            Log.wtf((String)TAG, (String)("ViewType instance has not been correctly mapped for viewType " + viewType));
            throw new IllegalStateException("ViewType instance has not been correctly mapped for viewType " + viewType);
        }
        return item.createViewHolder(this, this.mInflater, parent);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, Collections.unmodifiableList(new ArrayList()));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List payloads) {
        FlexibleViewHolder flexHolder;
        holder.itemView.setActivated(this.isSelected(position));
        if (holder.itemView.isActivated() && holder instanceof FlexibleViewHolder && (flexHolder = (FlexibleViewHolder)holder).getActivationElevation() > 0.0f) {
            ViewCompat.setElevation((View)flexHolder.itemView, (float)flexHolder.getActivationElevation());
        }
        if (!this.autoMap) {
            super.onBindViewHolder(holder, position, payloads);
        } else {
            T item = this.getItem(position);
            if (item != null) {
                holder.itemView.setEnabled(item.isEnabled());
                item.bindViewHolder(this, (RecyclerView.ViewHolder)holder, position, payloads);
            }
        }
    }

    public void setAutoCollapseOnExpand(boolean collapseOnExpand) {
        this.collapseOnExpand = collapseOnExpand;
    }

    public void setAutoScrollOnExpand(boolean scrollOnExpand) {
        this.scrollOnExpand = scrollOnExpand;
    }

    public boolean isExpanded(@IntRange(from=0L) int position) {
        return this.isExpanded(this.getItem(position));
    }

    public boolean isExpanded(@NonNull T item) {
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            return expandable.isExpanded();
        }
        return false;
    }

    public boolean isExpandable(@NonNull T item) {
        return item != null && item instanceof IExpandable;
    }

    public boolean hasSubItems(@NonNull IExpandable expandable) {
        return expandable != null && expandable.getSubItems() != null && expandable.getSubItems().size() > 0;
    }

    public IExpandable getExpandableOf(@IntRange(from=0L) int position) {
        return this.getExpandableOf(this.getItem(position));
    }

    public IExpandable getExpandableOf(@NonNull T child) {
        for (IFlexible parent : this.mItems) {
            IExpandable expandable;
            if (!this.isExpandable(parent) || !(expandable = (IExpandable)parent).isExpanded() || !this.hasSubItems(expandable)) continue;
            List list = expandable.getSubItems();
            for (IFlexible subItem : list) {
                if (subItem.isHidden() || !subItem.equals(child)) continue;
                return expandable;
            }
        }
        return null;
    }

    public int getExpandablePositionOf(@NonNull T child) {
        return this.getGlobalPositionOf(this.getExpandableOf(child));
    }

    public List<T> getSiblingsOf(@NonNull T child) {
        return this.getExpandableList(this.getExpandableOf(child));
    }

    public int getRelativePositionOf(@NonNull T child) {
        return this.getSiblingsOf(child).indexOf(child);
    }

    public List<T> getExpandedItems() {
        ArrayList<IFlexible> expandedItems = new ArrayList<IFlexible>();
        for (IFlexible item : this.mItems) {
            if (!this.isExpanded(item)) continue;
            expandedItems.add(item);
        }
        return expandedItems;
    }

    public List<Integer> getExpandedPositions() {
        ArrayList<Integer> expandedPositions = new ArrayList<Integer>();
        for (int i = 0; i < this.mItems.size() - 1; ++i) {
            IFlexible item = (IFlexible)this.mItems.get(i);
            if (!this.isExpanded(item)) continue;
            expandedPositions.add(i);
        }
        return expandedPositions;
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, false);
    }

    private int expand(int position, boolean expandAll) {
        T item = this.getItem(position);
        if (item == null || !item.isEnabled() || !this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (DEBUG) {
            Log.v((String)TAG, (String)("Request to Expand on position " + position + " expanded " + expandable.isExpanded() + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        if (!expandable.isExpanded() && !this.parentSelected && this.hasSubItems(expandable)) {
            if (this.collapseOnExpand && !expandAll && this.collapseAll() > 0) {
                position = this.getGlobalPositionOf((IFlexible)item);
            }
            List<T> subItems = this.getExpandableList(expandable);
            this.mItems.addAll(position + 1, subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(true);
            if (this.scrollOnExpand && !expandAll) {
                final int pos = position;
                final int count = subItemsCount;
                Handler animatorHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                    public boolean handleMessage(Message message) {
                        FlexibleAdapter.this.autoScroll(pos, count);
                        return true;
                    }
                });
                animatorHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler), 150L);
            }
            this.notifyItemRangeInserted(position + 1, subItemsCount);
            if (this.headersShown) {
                int count = 0;
                for (IFlexible subItem : subItems) {
                    if (!this.showHeaderOf(position + ++count, subItem)) continue;
                    ++count;
                }
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Expanded " + subItemsCount + " subItems on position=" + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount;
    }

    public int expandAll() {
        int expanded = 0;
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (this.expand(i, true) <= 0) continue;
            ++expanded;
        }
        return expanded;
    }

    public int collapse(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (item == null || !item.isEnabled() || !this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (DEBUG) {
            Log.v((String)TAG, (String)("Request to Collapse on position " + position + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        int recursiveCount = 0;
        if (expandable.isExpanded() && (!this.hasSubItemsSelected(expandable) || this.getPendingRemovedItem(item) != null)) {
            List<T> subItems = this.getExpandableList(expandable);
            recursiveCount = this.recursiveCollapse(subItems);
            this.mItems.removeAll(subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(false);
            this.notifyItemRangeRemoved(position + 1, subItemsCount);
            if (this.headersShown && !this.isHeader(item)) {
                for (IFlexible subItem : subItems) {
                    this.hideHeaderOf(subItem);
                }
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Collapsed " + subItemsCount + " subItems on position=" + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount + recursiveCount;
    }

    private int recursiveCollapse(List<T> subItems) {
        int collapsed = 0;
        for (IFlexible subItem : subItems) {
            if (!this.isExpanded(subItem)) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Recursive collapsing on expandable subItem " + subItem));
            }
            collapsed += this.collapse(this.getGlobalPositionOf(subItem));
        }
        return collapsed;
    }

    public int collapseAll() {
        int collapsed = 0;
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            if (this.collapse(i) <= 0) continue;
            ++collapsed;
        }
        return collapsed;
    }

    public void updateItem(@NonNull T item, @Nullable Object payload) {
        this.updateItem(this.getGlobalPositionOf((IFlexible)item), item, payload);
    }

    public void updateItem(@IntRange(from=0L) int position, @NonNull T item, @Nullable Object payload) {
        if (position < 0 || position >= this.mItems.size()) {
            Log.e((String)TAG, (String)"Cannot updateItem on position out of OutOfBounds!");
            return;
        }
        this.mItems.set(position, item);
        if (DEBUG) {
            Log.v((String)TAG, (String)("updateItem notifyItemChanged on position " + position));
        }
        this.notifyItemChanged(position, payload);
    }

    public void addItemWithDelay(final @IntRange(from=0L) int position, @NonNull T item, @IntRange(from=0L) long delay, boolean scrollToPosition) {
        this.mHandler.postDelayed(new Runnable((IFlexible)item, scrollToPosition){
            final /* synthetic */ IFlexible val$item;
            final /* synthetic */ boolean val$scrollToPosition;
            {
                this.val$item = iFlexible;
                this.val$scrollToPosition = bl;
            }

            @Override
            public void run() {
                if (FlexibleAdapter.this.addItem(position, this.val$item) && this.val$scrollToPosition) {
                    FlexibleAdapter.this.mRecyclerView.scrollToPosition(Math.min(Math.max(0, position), FlexibleAdapter.this.getItemCount() - 1));
                }
            }
        }, delay);
    }

    public boolean addItem(@IntRange(from=0L) int position, @NonNull T item) {
        if (item == null) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"addItem delegates addition to addItems!");
        }
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item);
        return this.addItems(position, items);
    }

    public boolean addItems(@IntRange(from=0L) int position, @NonNull List<T> items) {
        if (position < 0) {
            Log.e((String)TAG, (String)"Cannot addItems on negative position!");
            return false;
        }
        if (items == null || items.isEmpty()) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("addItems on position=" + position + " itemCount=" + items.size()));
        }
        if (position < this.mItems.size()) {
            this.mItems.addAll(position, items);
        } else {
            this.mItems.addAll(items);
        }
        this.notifyItemRangeInserted(position, items.size());
        if (this.headersShown && !this.recursive) {
            this.recursive = true;
            for (IFlexible item : items) {
                this.showHeaderOf(this.getGlobalPositionOf(item), item);
            }
            this.recursive = false;
        }
        if (!this.recursive && this.mUpdateListener != null && !this.multiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        return true;
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item) {
        return this.addSubItem(parentPosition, subPosition, item, false, null);
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item, boolean expandParent, @Nullable Object payload) {
        if (item == null) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        ArrayList<T> subItems = new ArrayList<T>(1);
        subItems.add(item);
        return this.addSubItems(parentPosition, subPosition, subItems, expandParent, payload);
    }

    public int addAllSubItemsFrom(@IntRange(from=0L) int parentPosition, @NonNull IExpandable parent, boolean expandParent, @Nullable Object payload) {
        List<T> subItems = this.getCurrentChildren(parent);
        this.addSubItems(parentPosition, 0, parent, subItems, expandParent, payload);
        return subItems.size();
    }

    public boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull List<T> items, boolean expandParent, @Nullable Object payload) {
        T parent = this.getItem(parentPosition);
        if (this.isExpandable(parent)) {
            IExpandable expandable = (IExpandable)parent;
            return this.addSubItems(parentPosition, subPosition, expandable, items, expandParent, payload);
        }
        Log.e((String)TAG, (String)"Passed parentPosition doesn't belong to an Expandable item!");
        return false;
    }

    private boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull IExpandable parent, @NonNull List<T> items, boolean expandParent, @Nullable Object payload) {
        boolean added = false;
        if (expandParent && !parent.isExpanded()) {
            this.expand(parentPosition);
        }
        if (parent.isExpanded()) {
            added = this.addItems(parentPosition + 1 + Math.max(0, subPosition), items);
        }
        if (payload != null) {
            this.notifyItemChanged(parentPosition, payload);
        }
        return added;
    }

    public void removeItem(@IntRange(from=0L) int position) {
        this.removeItem(position, null);
    }

    public void removeItem(@IntRange(from=0L) int position, @Nullable Object payload) {
        this.collapse(position);
        if (DEBUG) {
            Log.v((String)TAG, (String)"removeItem delegates removal to removeRange");
        }
        this.removeRange(position, 1, payload);
        this.clearSelection();
    }

    public void removeItems(@NonNull List<Integer> selectedPositions) {
        this.removeItems(selectedPositions, null);
    }

    public void removeItems(@NonNull List<Integer> selectedPositions, @Nullable Object payload) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems selectedPositions=" + selectedPositions + " payload=" + payload));
        }
        if (selectedPositions == null || selectedPositions.isEmpty()) {
            return;
        }
        Collections.sort(selectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return rhs - lhs;
            }
        });
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems after reverse sort selectedPositions=" + selectedPositions));
        }
        int positionStart = 0;
        int itemCount = 0;
        int lastPosition = selectedPositions.get(0);
        this.multiRange = true;
        for (Integer position : selectedPositions) {
            if (lastPosition - itemCount == position) {
                ++itemCount;
                positionStart = position;
            } else {
                this.adjustSelected = false;
                if (itemCount > 0) {
                    this.removeRange(positionStart, itemCount, payload);
                }
                positionStart = lastPosition = position.intValue();
                itemCount = 1;
            }
            this.collapse(position);
        }
        this.multiRange = false;
        this.clearSelection();
        if (itemCount > 0) {
            this.removeRange(positionStart, itemCount, payload);
        }
    }

    public void removeItemsOfType(Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        ArrayList<Integer> itemsToRemove = new ArrayList<Integer>();
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            if ((!this.autoMap || !viewTypeList.contains(((IFlexible)this.mItems.get(i)).getLayoutRes())) && !viewTypeList.contains(this.getItemViewType(i))) continue;
            itemsToRemove.add(i);
        }
        this.removeItems(itemsToRemove);
    }

    public void removeRange(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        this.removeRange(positionStart, itemCount, null);
    }

    public void removeRange(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount, @Nullable Object payload) {
        int initialCount = this.getItemCount();
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeRange positionStart=" + positionStart + " itemCount=" + itemCount));
        }
        if (positionStart < 0 || positionStart + itemCount > initialCount) {
            Log.e((String)TAG, (String)"Cannot removeRange with positionStart out of OutOfBounds!");
            return;
        }
        IHeader header = this.getHeaderOf(this.getItem(positionStart));
        if (header != null) {
            this.addToOrphanListIfNeeded(header, positionStart, itemCount);
            this.notifyItemChanged(this.getGlobalPositionOf(header), payload);
        }
        int parentPosition = -1;
        IExpandable parent = null;
        for (int position = positionStart; position < positionStart + itemCount; ++position) {
            T item = this.getItem(positionStart);
            if (!this.permanentDelete) {
                assert (item != null);
                if (parent == null) {
                    parent = this.getExpandableOf(item);
                }
                if (this.isExpandable(item) || parent == null) {
                    this.createRestoreItemInfo(positionStart, item, payload);
                } else {
                    parentPosition = this.createRestoreSubItemInfo(parent, item, payload);
                }
            }
            if (this.unlinkOnRemoveHeader && this.isHeader(item)) {
                ISectionable sectionable;
                do {
                    if ((sectionable = this.getSectionableOf((IHeader)item)) == null) continue;
                    sectionable.setHeader(null);
                } while (sectionable != null);
            }
            this.mItems.remove(positionStart);
        }
        if (parentPosition >= 0) {
            this.adjustSelected = false;
            this.notifyItemRangeRemoved(positionStart, itemCount);
            if (payload != null) {
                this.notifyItemChanged(parentPosition, payload);
            }
        } else {
            this.notifyItemRangeRemoved(positionStart, itemCount);
        }
        if (this.removeOrphanHeaders) {
            for (IHeader orphanHeader : this.mOrphanHeaders) {
                int headerPosition = this.getGlobalPositionOf(orphanHeader);
                if (headerPosition < 0) continue;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("Removing orphan header " + orphanHeader));
                }
                this.createRestoreItemInfo(headerPosition, orphanHeader, payload);
                this.mItems.remove(headerPosition);
                this.notifyItemRemoved(headerPosition);
            }
            this.mOrphanHeaders.clear();
        }
        if (this.mUpdateListener != null && !this.multiRange && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    public void removeAllSelectedItems() {
        this.removeItems(this.getSelectedPositions());
    }

    public void removeAllSelectedItems(@Nullable Object payload) {
        this.removeItems(this.getSelectedPositions(), payload);
    }

    public boolean isPermanentDelete() {
        return this.permanentDelete;
    }

    public void setPermanentDelete(boolean permanentDelete) {
        this.permanentDelete = permanentDelete;
    }

    public boolean isRestoreWithSelection() {
        return this.restoreSelection;
    }

    public void setRestoreSelectionOnUndo(boolean restoreSelection) {
        this.restoreSelection = restoreSelection;
    }

    public void restoreDeletedItems() {
        this.stopUndoTimer();
        this.multiRange = true;
        int initialCount = this.getItemCount();
        this.clearSelection();
        for (int i = this.mRestoreList.size() - 1; i >= 0; --i) {
            this.adjustSelected = false;
            RestoreInfo restoreInfo = this.mRestoreList.get(i);
            IHeader header = this.getHeaderOf(restoreInfo.item);
            if (header != null) {
                this.notifyItemChanged(this.getGlobalPositionOf(header), restoreInfo.payload);
            }
            if (restoreInfo.relativePosition >= 0) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Child " + restoreInfo));
                }
                if (this.hasSearchText() && !this.filterObject(restoreInfo.item, this.getSearchText())) continue;
                this.addSubItem(restoreInfo.getRefPosition(), restoreInfo.relativePosition, restoreInfo.item, false, restoreInfo.payload);
            } else {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Parent " + restoreInfo));
                }
                if (this.hasSearchText() && !this.filterExpandableObject(restoreInfo.item, this.getSearchText())) continue;
                this.addItem(restoreInfo.getRestorePosition(), restoreInfo.item);
            }
            restoreInfo.item.setHidden(false);
        }
        if (this.restoreSelection && !this.mRestoreList.isEmpty()) {
            if (this.isExpandable(this.mRestoreList.get((int)0).item) || this.getExpandableOf(this.mRestoreList.get((int)0).item) == null) {
                this.parentSelected = true;
            } else {
                this.childSelected = true;
            }
            for (RestoreInfo restoreInfo : this.mRestoreList) {
                if (!restoreInfo.item.isSelectable()) continue;
                this.getSelectedPositions().add(this.getGlobalPositionOf((IFlexible)restoreInfo.item));
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Selected positions after restore " + this.getSelectedPositions()));
            }
        }
        this.multiRange = false;
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        this.emptyBin();
    }

    public synchronized void emptyBin() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"emptyBin!");
        }
        this.mRestoreList.clear();
    }

    public void startUndoTimer(OnDeleteCompleteListener listener) {
        this.startUndoTimer(0L, listener);
    }

    public void startUndoTimer(long timeout, OnDeleteCompleteListener listener) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)1, (Object)listener), timeout > 0L ? timeout : 5000L);
    }

    protected void stopUndoTimer() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public boolean isRestoreInTime() {
        return this.mRestoreList != null && !this.mRestoreList.isEmpty();
    }

    public List<T> getDeletedItems() {
        ArrayList deletedItems = new ArrayList();
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            deletedItems.add(restoreInfo.item);
        }
        return deletedItems;
    }

    public IExpandable getExpandableOfDeletedChild(T child) {
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (!restoreInfo.item.equals(child) || !this.isExpandable(restoreInfo.refItem)) continue;
            return (IExpandable)restoreInfo.refItem;
        }
        return null;
    }

    public List<T> getDeletedChildren(IExpandable expandable) {
        ArrayList deletedChild = new ArrayList();
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (restoreInfo.refItem == null || !restoreInfo.refItem.equals(expandable) || restoreInfo.relativePosition < 0) continue;
            deletedChild.add(restoreInfo.item);
        }
        return deletedChild;
    }

    public List<T> getCurrentChildren(@NonNull IExpandable expandable) {
        if (expandable == null || !this.hasSubItems(expandable)) {
            return new ArrayList();
        }
        ArrayList subItems = new ArrayList(expandable.getSubItems());
        if (!this.mRestoreList.isEmpty()) {
            subItems.removeAll(this.getDeletedChildren(expandable));
        }
        return subItems;
    }

    public boolean hasSearchText() {
        return this.mSearchText != null && !this.mSearchText.isEmpty();
    }

    public boolean hasNewSearchText(String newText) {
        return !this.mOldSearchText.equalsIgnoreCase(newText);
    }

    public String getSearchText() {
        return this.mSearchText;
    }

    public void setSearchText(String searchText) {
        this.mSearchText = searchText != null ? searchText.trim().toLowerCase(Locale.getDefault()) : "";
    }

    public final void setNotifyChangeOfUnfilteredItems(boolean notifyChange) {
        this.mNotifyChangeOfUnfilteredItems = notifyChange;
    }

    public void filterItems(@NonNull List<T> unfilteredItems, @IntRange(from=0L) long delay) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)0, unfilteredItems), delay > 0L ? delay : 0L);
    }

    public synchronized void filterItems(@NonNull List<T> unfilteredItems) {
        List<Object> values = new ArrayList();
        this.filtering = true;
        int initialCount = this.getItemCount();
        if (this.hasSearchText()) {
            int newOriginalPosition = -1;
            for (IFlexible item : unfilteredItems) {
                IExpandable expandable;
                if (!this.filterExpandableObject(item, this.getSearchText())) continue;
                RestoreInfo restoreInfo = this.getPendingRemovedItem(item);
                if (restoreInfo != null) {
                    restoreInfo.filterRefItem = ++newOriginalPosition < values.size() ? (IFlexible)values.get(newOriginalPosition) : null;
                    continue;
                }
                values.add(item);
                ++newOriginalPosition;
                if (!this.isExpandable(item) || !(expandable = (IExpandable)item).isExpanded()) continue;
                ArrayList<IFlexible> filteredSubItems = new ArrayList<IFlexible>();
                List subItems = expandable.getSubItems();
                for (IFlexible subItem : subItems) {
                    if (subItem.isHidden()) continue;
                    filteredSubItems.add(subItem);
                }
                values.addAll(filteredSubItems);
                newOriginalPosition += filteredSubItems.size();
            }
        } else if (this.hasNewSearchText(this.mSearchText)) {
            values = unfilteredItems;
            if (!this.mRestoreList.isEmpty()) {
                for (RestoreInfo restoreInfo : this.mRestoreList) {
                    restoreInfo.clearFilterRef();
                    restoreInfo.refItem = (IFlexible)values.get(Math.max(0, values.indexOf(restoreInfo.item) - 1));
                }
                values.removeAll(this.getDeletedItems());
            }
            this.resetFilterFlags(values);
        }
        if (this.hasNewSearchText(this.mSearchText)) {
            this.mOldSearchText = this.mSearchText;
            this.animateTo(values);
            if (!this.hasSearchText()) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        FlexibleAdapter.this.showAllHeaders();
                    }
                }, 50L);
            }
        }
        this.filtering = false;
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    private boolean filterExpandableObject(T item, String constraint) {
        boolean filtered = false;
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            expandable.setExpanded(false);
            Iterator<T> i$ = this.getCurrentChildren(expandable).iterator();
            while (i$.hasNext()) {
                IFlexible subItem;
                subItem.setHidden(!this.filterObject(subItem = (IFlexible)i$.next(), constraint));
                if (filtered || subItem.isHidden()) continue;
                filtered = true;
            }
            expandable.setExpanded(filtered);
        }
        return filtered || this.filterObject(item, constraint);
    }

    protected boolean filterObject(T item, String constraint) {
        if (item instanceof IFilterable) {
            IFilterable filterable = (IFilterable)item;
            return filterable.filter(constraint);
        }
        return false;
    }

    public List<T> animateTo(List<T> models) {
        this.applyAndAnimateRemovals(this.mItems, models);
        this.applyAndAnimateAdditions(this.mItems, models);
        return this.mItems;
    }

    protected void applyAndAnimateRemovals(List<T> from, List<T> newItems) {
        int out = 0;
        for (int i = from.size() - 1; i >= 0; --i) {
            IFlexible item = (IFlexible)from.get(i);
            if (!newItems.contains(item)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateRemovals remove position=" + i + " item=" + item));
                }
                from.remove(i);
                this.notifyItemRemoved(i);
                ++out;
                continue;
            }
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateRemovals   keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateRemovals total out=" + out + " in=" + newItems.size()));
        }
    }

    protected void applyAndAnimateAdditions(List<T> from, List<T> newItems) {
        int out = 0;
        int count = newItems.size();
        for (int i = 0; i < count; ++i) {
            IFlexible item = (IFlexible)newItems.get(i);
            if (!from.contains(item)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateAdditions  add position=" + i + " item=" + item));
                }
                from.add(i, item);
                this.notifyItemInserted(i);
                continue;
            }
            if (!this.mNotifyChangeOfUnfilteredItems) continue;
            ++out;
            this.notifyItemChanged(i, this.mNotifyChangeOfUnfilteredItems);
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateAdditions keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateAdditions total out=" + out + " in=" + newItems.size()));
        }
    }

    public final ItemTouchHelper getItemTouchHelper() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper;
    }

    public boolean isLongPressDragEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isLongPressDragEnabled();
    }

    public final void setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.initializeItemTouchHelper();
        this.longPressDragEnabled = longPressDragEnabled;
        this.mItemTouchHelperCallback.setLongPressDragEnabled(longPressDragEnabled);
    }

    public boolean isHandleDragEnabled() {
        return this.handleDragEnabled;
    }

    public void setHandleDragEnabled(boolean handleDragEnabled) {
        this.handleDragEnabled = handleDragEnabled;
    }

    public final boolean isSwipeEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isItemViewSwipeEnabled();
    }

    public final void setSwipeEnabled(boolean swipeEnabled) {
        this.initializeItemTouchHelper();
        this.swipeEnabled = swipeEnabled;
        this.mItemTouchHelperCallback.setSwipeEnabled(swipeEnabled);
    }

    @CallSuper
    public void moveItem(int fromPosition, int toPosition) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("moveItem from=" + fromPosition + "[" + (this.isSelected(fromPosition) ? "selected" : "unselected") + "] to=" + toPosition + "[" + (this.isSelected(toPosition) ? "selected" : "unselected") + "]"));
            Log.v((String)TAG, (String)("moveItem beforeSwap fromItem=" + this.getItem(fromPosition) + " toItem=" + this.getItem(toPosition)));
        }
        Collections.swap(this.mItems, fromPosition, toPosition);
        if (this.isSelected(fromPosition) && !this.isSelected(toPosition) || !this.isSelected(fromPosition) && this.isSelected(toPosition)) {
            super.toggleSelection(fromPosition);
            super.toggleSelection(toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
        if (DEBUG) {
            Log.v((String)TAG, (String)("moveItem afterSwap fromItem=" + this.getItem(fromPosition) + " toItem=" + this.getItem(toPosition)));
        }
        if (this.headersShown) {
            T fromItem = this.getItem(toPosition);
            T toItem = this.getItem(fromPosition);
            if (toItem instanceof IHeader && fromItem instanceof IHeader) {
                if (fromPosition < toPosition) {
                    int oldPosition = toPosition + 1;
                    this.unlinkHeaderFrom(this.getItem(oldPosition), true);
                    this.linkHeaderTo(this.getItem(oldPosition), (IHeader)fromItem, true);
                } else {
                    int oldPosition = fromPosition + 1;
                    this.unlinkHeaderFrom(this.getItem(oldPosition), true);
                    this.linkHeaderTo(this.getItem(oldPosition), (IHeader)toItem, true);
                }
            } else if (toItem instanceof IHeader) {
                int newPosition;
                int oldPosition = fromPosition < toPosition ? toPosition + 1 : toPosition;
                int n = newPosition = fromPosition < toPosition ? toPosition : fromPosition + 1;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("NewPosition " + this.getItem(newPosition)));
                }
                this.unlinkHeaderFrom(this.getItem(oldPosition), true);
                this.linkHeaderTo(this.getItem(newPosition), (IHeader)toItem, true);
                if (this.getItem(fromPosition - 2) instanceof IHeader) {
                    this.linkHeaderTo(this.getItem(fromPosition - 1), (IHeader)this.getItem(fromPosition - 2), true);
                }
            } else if (fromItem instanceof IHeader) {
                int oldPosition = fromPosition < toPosition ? fromPosition : fromPosition + 1;
                int newPosition = fromPosition < toPosition ? toPosition + 1 : fromPosition;
                this.unlinkHeaderFrom(this.getItem(oldPosition), true);
                this.linkHeaderTo(this.getItem(newPosition), (IHeader)fromItem, true);
            } else {
                int oldPosition = fromPosition < toPosition ? toPosition : fromPosition;
                int newPosition = fromPosition < toPosition ? fromPosition : toPosition;
                IHeader header = this.unlinkHeaderFrom(this.getItem(oldPosition), true);
                if (header != null) {
                    this.linkHeaderTo(this.getItem(newPosition), header, true);
                }
            }
        }
    }

    @Override
    public boolean shouldMove(int fromPosition, int toPosition) {
        return true;
    }

    @Override
    @CallSuper
    public boolean onItemMove(int fromPosition, int toPosition) {
        this.moveItem(fromPosition, toPosition);
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onItemMove(fromPosition, toPosition);
        }
        return true;
    }

    @Override
    @CallSuper
    public void onItemSwiped(int position, int direction) {
        if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onItemSwipe(position, direction);
        }
    }

    private void initializeItemTouchHelper() {
        if (this.mItemTouchHelper == null) {
            if (this.mRecyclerView == null) {
                throw new IllegalStateException("RecyclerView cannot be null. Enabling LongPressDrag or Swipe must be done after the Adapter is added to the RecyclerView.");
            }
            this.mItemTouchHelperCallback = new ItemTouchHelperCallback(this);
            this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.mItemTouchHelperCallback);
            this.mItemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    private void mapViewTypesFrom(Iterable<T> items) {
        if (items != null) {
            for (IFlexible item : items) {
                this.mapViewTypeFrom(item);
            }
        }
    }

    private void mapViewTypeFrom(T item) {
        if (item != null && !this.mTypeInstances.containsKey(item.getLayoutRes())) {
            this.mTypeInstances.put(item.getLayoutRes(), item);
            if (DEBUG) {
                Log.i((String)TAG, (String)("Mapped viewType " + item.getLayoutRes() + " from " + item.getClass().getSimpleName()));
            }
        }
    }

    private T getViewTypeInstance(int viewType) {
        return (T)((IFlexible)this.mTypeInstances.get(viewType));
    }

    private void resetFilterFlags(List<T> items) {
        for (IFlexible item : items) {
            if (!this.isExpandable(item)) continue;
            IExpandable expandable = (IExpandable)item;
            expandable.setExpanded(false);
            List subItems = expandable.getSubItems();
            for (IFlexible subItem : subItems) {
                subItem.setHidden(false);
            }
        }
    }

    private RestoreInfo getPendingRemovedItem(T item) {
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (!restoreInfo.item.equals(item)) continue;
            return restoreInfo;
        }
        return null;
    }

    private int createRestoreSubItemInfo(IExpandable expandable, T item, @Nullable Object payload) {
        int parentPosition = this.getGlobalPositionOf(expandable);
        List<T> siblings = this.getExpandableList(expandable);
        int childPosition = siblings.indexOf(item);
        item.setHidden(true);
        this.mRestoreList.add(new RestoreInfo(this, (IFlexible)expandable, item, childPosition, payload));
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled Child " + this.mRestoreList.get(this.mRestoreList.size() - 1) + " with Parent position=" + parentPosition));
        }
        return parentPosition;
    }

    private void createRestoreItemInfo(int position, T item, @Nullable Object payload) {
        IExpandable expandable;
        if (this.isExpanded(item)) {
            this.collapse(position);
        }
        item.setHidden(true);
        Object refItem = this.getItem(position - 1);
        if (refItem != null && (expandable = this.getExpandableOf(refItem)) != null) {
            refItem = expandable;
        }
        this.mRestoreList.add(new RestoreInfo(this, refItem, item, payload));
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled Parent " + this.mRestoreList.get(this.mRestoreList.size() - 1) + " on position=" + position));
        }
    }

    private List<T> getExpandableList(IExpandable expandable) {
        ArrayList<IFlexible> subItems = new ArrayList<IFlexible>();
        if (expandable != null && this.hasSubItems(expandable)) {
            List allSubItems = expandable.getSubItems();
            for (IFlexible subItem : allSubItems) {
                if (subItem.isHidden()) continue;
                subItems.add(subItem);
            }
        }
        return subItems;
    }

    private boolean hasSubItemsSelected(IExpandable expandable) {
        for (IFlexible subItem : this.getExpandableList(expandable)) {
            if (!this.isSelected(this.getGlobalPositionOf(subItem))) continue;
            return true;
        }
        return false;
    }

    private void autoScroll(int position, int subItemsCount) {
        int firstVisibleItem = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition();
        int lastVisibleItem = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
        int itemsToShow = position + subItemsCount - lastVisibleItem;
        if (DEBUG) {
            Log.v((String)TAG, (String)("itemsToShow=" + itemsToShow + " firstVisibleItem=" + firstVisibleItem + " lastVisibleItem=" + lastVisibleItem + " RvChildCount=" + this.mRecyclerView.getChildCount()));
        }
        if (itemsToShow > 0) {
            int scrollMax = position - firstVisibleItem;
            int scrollMin = Math.max(0, position + subItemsCount - lastVisibleItem);
            int scrollBy = Math.min(scrollMax, scrollMin);
            int scrollTo = firstVisibleItem + scrollBy;
            if (DEBUG) {
                Log.v((String)TAG, (String)("scrollMin=" + scrollMin + " scrollMax=" + scrollMax + " scrollBy=" + scrollBy + " scrollTo=" + scrollTo));
            }
            this.mRecyclerView.smoothScrollToPosition(scrollTo);
        } else if (position < firstVisibleItem) {
            this.mRecyclerView.smoothScrollToPosition(position);
        }
    }

    private void adjustSelected(int startPosition, int itemCount) {
        List<Integer> selectedPositions = this.getSelectedPositions();
        boolean adjusted = false;
        for (Integer position : selectedPositions) {
            if (position < startPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adjust Selected position " + position + " to " + Math.max(position + itemCount, startPosition)));
            }
            selectedPositions.set(selectedPositions.indexOf(position), Math.max(position + itemCount, startPosition));
            adjusted = true;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedSelected=" + this.getSelectedPositions()));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            super.onSaveInstanceState(outState);
            outState.putBoolean(EXTRA_CHILD, this.childSelected);
            outState.putBoolean(EXTRA_PARENT, this.parentSelected);
            outState.putBoolean(EXTRA_HEADERS, this.headersShown);
        }
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            super.onRestoreInstanceState(savedInstanceState);
            this.parentSelected = savedInstanceState.getBoolean(EXTRA_PARENT);
            this.childSelected = savedInstanceState.getBoolean(EXTRA_CHILD);
            this.headersShown = savedInstanceState.getBoolean(EXTRA_HEADERS);
            if (this.headersShown) {
                this.showAllHeaders();
            }
        }
    }

    private static class RestoreInfo {
        int refPosition = -1;
        int relativePosition = -1;
        T refItem = null;
        T filterRefItem = null;
        T item = null;
        Object payload = false;
        final /* synthetic */ FlexibleAdapter this$0;

        public RestoreInfo(T refItem, T item, Object payload) {
            this(var1_1, (IFlexible)refItem, (IFlexible)item, -1, payload);
        }

        public RestoreInfo(T refItem, T item, int relativePosition, Object payload) {
            this.this$0 = var1_1;
            this.refItem = refItem;
            this.item = item;
            this.relativePosition = relativePosition;
            this.payload = payload;
        }

        public int getRefPosition() {
            if (this.refPosition < 0) {
                this.refPosition = this.this$0.getGlobalPositionOf((IFlexible)(this.filterRefItem != null ? this.filterRefItem : this.refItem));
            }
            return this.refPosition;
        }

        public int getRestorePosition() {
            Object item = this.this$0.getItem(this.getRefPosition());
            if (this.this$0.isExpanded(item)) {
                this.refPosition += this.this$0.getExpandableList((IExpandable)item).size();
            }
            return this.refPosition + 1;
        }

        public void clearFilterRef() {
            this.filterRefItem = null;
            this.refPosition = -1;
        }

        public String toString() {
            return "RestoreInfo[item=" + this.item + ", refItem=" + this.refItem + ", filterRefItem=" + this.filterRefItem + "]";
        }
    }

    private class AdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private AdapterDataObserver() {
        }

        private void adjustPositions(int positionStart, int itemCount) {
            if (!FlexibleAdapter.this.filtering) {
                if (FlexibleAdapter.this.adjustSelected) {
                    FlexibleAdapter.this.adjustSelected(positionStart, itemCount);
                }
                FlexibleAdapter.this.adjustSelected = true;
            }
        }

        private void updateOrClearHeader() {
            if (FlexibleAdapter.this.mStickyHeaderHelper != null && !FlexibleAdapter.this.multiRange && !FlexibleAdapter.this.filtering) {
                FlexibleAdapter.this.mStickyHeaderHelper.updateOrClearHeader(true);
            }
        }

        public void onChanged() {
            FlexibleAdapter.this.initializeItems();
            this.updateOrClearHeader();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, itemCount);
            this.updateOrClearHeader();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, -itemCount);
            this.updateOrClearHeader();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.updateOrClearHeader();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.updateOrClearHeader();
        }
    }

    public static interface OnStickyHeaderChangeListener {
        public void onStickyHeaderChange(int var1);
    }

    public static interface OnItemSwipeListener {
        public void onItemSwipe(int var1, int var2);
    }

    public static interface OnItemMoveListener {
        public void onItemMove(int var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(int var1);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(int var1);
    }

    public static interface OnDeleteCompleteListener {
        public void onDeleteConfirmed();
    }

    public static interface OnUpdateListener {
        public void onUpdateEmptyView(int var1);
    }
}

