/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import eu.davidea.fastscroller.FastScroller;
import eu.davidea.flexibleadapter.R;
import eu.davidea.flexibleadapter.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class SelectableAdapter
extends RecyclerView.Adapter
implements FastScroller.BubbleTextCreator,
FastScroller.OnScrollStateChangeListener {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    public static boolean DEBUG = false;
    public static final int MODE_IDLE = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_MULTI = 2;
    private ArrayList<Integer> mSelectedPositions = new ArrayList();
    private int mMode = 0;
    protected RecyclerView mRecyclerView;
    protected FastScroller mFastScroller;
    protected boolean mSelectAll = false;
    protected boolean mLastItemInActionMode = false;

    public static void enableLogs(boolean enable) {
        DEBUG = enable;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRecyclerView = null;
    }

    public void setMode(int mode) {
        this.mMode = mode;
        this.mLastItemInActionMode = mode == 0;
    }

    public int getMode() {
        return this.mMode;
    }

    public boolean isSelectAll() {
        return this.mSelectAll;
    }

    public boolean isLastItemInActionMode() {
        return this.mLastItemInActionMode;
    }

    public void resetActionModeFlags() {
        this.mSelectAll = false;
        this.mLastItemInActionMode = false;
    }

    public boolean isSelected(int position) {
        return this.mSelectedPositions.contains(position);
    }

    public abstract boolean isSelectable(int var1);

    public void toggleSelection(int position) {
        int index;
        if (position < 0) {
            return;
        }
        if (this.mMode == 1) {
            this.clearSelection();
        }
        if ((index = this.mSelectedPositions.indexOf(position)) != -1) {
            this.mSelectedPositions.remove(index);
        } else {
            this.mSelectedPositions.add(position);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("toggleSelection " + (index != -1 ? "removed" : "added") + " selection on position " + position + ", current selection " + this.mSelectedPositions));
        }
    }

    public void selectAll(Integer ... viewTypes) {
        this.mSelectAll = true;
        List<Integer> viewTypesToSelect = Arrays.asList(viewTypes);
        if (DEBUG) {
            Log.v((String)TAG, (String)("selectAll ViewTypes to include " + viewTypesToSelect));
        }
        this.mSelectedPositions = new ArrayList(this.getItemCount());
        int positionStart = 0;
        int itemCount = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.isSelectable(i) && (viewTypesToSelect.isEmpty() || viewTypesToSelect.contains(this.getItemViewType(i)))) {
                this.mSelectedPositions.add(i);
                ++itemCount;
                continue;
            }
            if (positionStart + itemCount != i) continue;
            this.handleSelection(positionStart, itemCount);
            itemCount = 0;
            positionStart = i;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("selectAll notifyItemRangeChanged from positionStart=" + positionStart + " itemCount=" + this.getItemCount()));
        }
        this.handleSelection(positionStart, this.getItemCount());
    }

    public void clearSelection() {
        Collections.sort(this.mSelectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return lhs - rhs;
            }
        });
        if (DEBUG) {
            Log.v((String)TAG, (String)("clearSelection " + this.mSelectedPositions));
        }
        Iterator<Integer> iterator = this.mSelectedPositions.iterator();
        int positionStart = 0;
        int itemCount = 0;
        while (iterator.hasNext()) {
            int position = iterator.next();
            iterator.remove();
            if (positionStart + itemCount == position) {
                ++itemCount;
                continue;
            }
            this.handleSelection(positionStart, itemCount);
            positionStart = position;
            itemCount = 1;
        }
        this.handleSelection(positionStart, itemCount);
    }

    private void handleSelection(int positionStart, int itemCount) {
        if (itemCount > 0) {
            this.notifyItemRangeChanged(positionStart, itemCount);
        }
    }

    public int getSelectedItemCount() {
        return this.mSelectedPositions.size();
    }

    public List<Integer> getSelectedPositions() {
        return this.mSelectedPositions;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putIntegerArrayList(TAG, this.mSelectedPositions);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        this.mSelectedPositions = savedInstanceState.getIntegerArrayList(TAG);
    }

    public void toggleFastScroller() {
        if (this.mFastScroller != null) {
            if (this.mFastScroller.getVisibility() != 0) {
                this.mFastScroller.setVisibility(0);
            } else {
                this.mFastScroller.setVisibility(8);
            }
        }
    }

    public boolean isFastScrollerEnabled() {
        return this.mFastScroller != null && this.mFastScroller.getVisibility() == 0;
    }

    public FastScroller getFastScroller() {
        return this.mFastScroller;
    }

    public void setFastScroller(@NonNull FastScroller fastScroller, int accentColor) {
        this.setFastScroller(fastScroller, accentColor, null);
    }

    public void setFastScroller(@NonNull FastScroller fastScroller, int accentColor, FastScroller.OnScrollStateChangeListener stateChangeListener) {
        if (this.mRecyclerView == null) {
            throw new IllegalStateException("RecyclerView cannot be null. Setup FastScroller after the Adapter is added to the RecyclerView.");
        }
        this.mFastScroller = fastScroller;
        this.mFastScroller.setRecyclerView(this.mRecyclerView);
        this.mFastScroller.addOnScrollStateChangeListener(stateChangeListener);
        accentColor = Utils.fetchAccentColor(fastScroller.getContext(), accentColor);
        this.mFastScroller.setViewsToUse(R.layout.library_fast_scroller_layout, R.id.fast_scroller_bubble, R.id.fast_scroller_handle, accentColor);
    }

    @Override
    public String onCreateBubbleText(int position) {
        return String.valueOf(position + 1);
    }

    @Override
    public void onFastScrollerStateChange(boolean scrolling) {
    }
}

