/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.graphics.Canvas;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.IHeader;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class StickyHeaderDecoration
extends RecyclerView.ItemDecoration {
    private FlexibleAdapter mAdapter;
    private Map<IHeader, View> mHeaderCache;
    private int maxCachedHeaders;

    public StickyHeaderDecoration(FlexibleAdapter adapter, int maxCachedHeaders) {
        this.mAdapter = adapter;
        this.mHeaderCache = new HashMap<IHeader, View>();
        this.maxCachedHeaders = maxCachedHeaders;
    }

    private View getHeader(RecyclerView recyclerView, int position) {
        IHeader key = this.mAdapter.getSectionHeader(position);
        if (key != null && this.mHeaderCache.containsKey(key)) {
            return this.mHeaderCache.get(key);
        }
        if (key == null) {
            return null;
        }
        int headerPosition = this.mAdapter.getGlobalPositionOf(key);
        if (headerPosition < 0) {
            return null;
        }
        RecyclerView.ViewHolder holder = this.mAdapter.onCreateViewHolder((ViewGroup)recyclerView, this.mAdapter.getItemViewType(headerPosition));
        View header = holder.itemView;
        this.mAdapter.onBindViewHolder(holder, headerPosition);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)recyclerView.getWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)recyclerView.getHeight(), (int)0);
        int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(recyclerView.getPaddingLeft() + recyclerView.getPaddingRight()), (int)header.getLayoutParams().width);
        int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(recyclerView.getPaddingTop() + recyclerView.getPaddingBottom()), (int)header.getLayoutParams().height);
        header.measure(childWidth, childHeight);
        header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
        if (this.mHeaderCache.keySet().size() == this.maxCachedHeaders) {
            this.clearHeadersCache();
        }
        this.mHeaderCache.put(key, header);
        return header;
    }

    public void onDrawOver(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        if (recyclerView.getChildCount() < 0) {
            return;
        }
        View child = recyclerView.getChildAt(0);
        int adapterPos = recyclerView.getChildAdapterPosition(child);
        View headerView = this.getHeader(recyclerView, adapterPos);
        if (headerView != null) {
            int top = this.getHeaderTop(recyclerView, child, adapterPos);
            int left = child.getLeft();
            canvas.save();
            canvas.translate((float)left, (float)top);
            headerView.draw(canvas);
            canvas.restore();
        }
    }

    private int getHeaderTop(RecyclerView recyclerView, View child, int adapterPos) {
        int top = Math.max(0, (int)child.getY());
        IHeader current = this.mAdapter.getSectionHeader(adapterPos);
        if (current == null || recyclerView.getChildCount() < 1) {
            return top;
        }
        View nextItemView = recyclerView.getChildAt(1);
        int adapterPosHere = recyclerView.getChildAdapterPosition(nextItemView);
        IHeader next = this.mAdapter.getSectionHeader(adapterPosHere);
        if (next != null && !next.equals(current)) {
            View nextHeaderView = this.getHeader(recyclerView, adapterPosHere);
            if (nextHeaderView == null) {
                return top;
            }
            int offset = (int)nextItemView.getY() - nextHeaderView.getHeight();
            if (offset < 0) {
                return offset;
            }
        }
        return top;
    }

    public void clearHeadersCache() {
        this.mHeaderCache.clear();
    }

    public IHeader findHeaderViewUnder(float x, float y) {
        for (Map.Entry<IHeader, View> entry : this.mHeaderCache.entrySet()) {
            View child = entry.getValue();
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return entry.getKey();
        }
        return null;
    }
}

