/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.widget.TextView;
import java.util.Locale;

public final class Utils {
    public static final int INVALID_COLOR = -1;
    private static int colorAccent = -1;

    public static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static void highlightText(Context context, TextView textView, String originalText, String constraint, int defColor) {
        Spannable spanText = Spannable.Factory.getInstance().newSpannable((CharSequence)originalText);
        int i = originalText.toLowerCase(Locale.getDefault()).indexOf(constraint);
        if (i != -1) {
            spanText.setSpan((Object)new ForegroundColorSpan(Utils.fetchAccentColor(context, defColor)), i, i + constraint.length(), 33);
            spanText.setSpan((Object)new StyleSpan(1), i, i + constraint.length(), 33);
            textView.setText((CharSequence)spanText, TextView.BufferType.SPANNABLE);
        } else {
            textView.setText((CharSequence)originalText, TextView.BufferType.NORMAL);
        }
    }

    public static void resetAccentColor() {
        colorAccent = -1;
    }

    @TargetApi(value=21)
    public static int fetchAccentColor(Context context, int defColor) {
        if (colorAccent == -1) {
            if (Utils.hasLollipop()) {
                TypedArray androidAttr = context.getTheme().obtainStyledAttributes(new int[]{16843829});
                colorAccent = androidAttr.getColor(0, defColor);
                androidAttr.recycle();
            } else {
                colorAccent = defColor;
            }
        }
        return colorAccent;
    }

    public static int dpToPx(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return Math.round(dp * scale);
    }
}

