/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.support.annotation.CallSuper;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.viewholders.FlexibleViewHolder;

public abstract class ExpandableViewHolder
extends FlexibleViewHolder {
    protected final FlexibleAdapter mAdapter;

    public ExpandableViewHolder(View view, FlexibleAdapter adapter) {
        super(view, adapter);
        this.mAdapter = adapter;
    }

    protected boolean isViewExpandableOnClick() {
        return true;
    }

    protected boolean isViewCollapsibleOnLongClick() {
        return true;
    }

    @CallSuper
    protected void toggleExpansion() {
        int position = this.getFlexibleAdapterPosition();
        if (this.mAdapter.isExpanded(position)) {
            this.collapseView(position);
        } else if (!this.mAdapter.isSelected(position)) {
            this.expandView(position);
        }
    }

    @CallSuper
    protected void expandView(int position) {
        this.mAdapter.expand(position);
    }

    @CallSuper
    protected void collapseView(int position) {
        this.mAdapter.collapse(position);
    }

    @Override
    public void onClick(View view) {
        if (this.isViewExpandableOnClick()) {
            this.toggleExpansion();
        }
        super.onClick(view);
    }

    @Override
    public boolean onLongClick(View view) {
        int position = this.getFlexibleAdapterPosition();
        if (this.isViewCollapsibleOnLongClick()) {
            this.collapseView(position);
        }
        return super.onLongClick(view);
    }

    @Override
    public void onActionStateChanged(int position, int actionState) {
        if (this.mAdapter.isExpanded(this.getFlexibleAdapterPosition())) {
            this.collapseView(position);
        }
        super.onActionStateChanged(position, actionState);
    }
}

