/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.fastscroller;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import eu.davidea.flexibleadapter.R;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class FastScroller
extends FrameLayout {
    private static final int BUBBLE_ANIMATION_DURATION = 300;
    private static final int TRACK_SNAP_RANGE = 5;
    private TextView bubble;
    private ImageView handle;
    private int height;
    private boolean isInitialized = false;
    private ObjectAnimator currentAnimator;
    private RecyclerView recyclerView;
    private RecyclerView.LayoutManager layoutManager;
    private BubbleTextCreator bubbleTextCreator;
    private List<OnScrollStateChangeListener> scrollStateChangeListeners = new ArrayList<OnScrollStateChangeListener>();
    private final RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (FastScroller.this.bubble == null || FastScroller.this.handle.isSelected()) {
                return;
            }
            int verticalScrollOffset = recyclerView.computeVerticalScrollOffset();
            int verticalScrollRange = recyclerView.computeVerticalScrollRange();
            float proportion = (float)verticalScrollOffset / ((float)verticalScrollRange - (float)FastScroller.this.height);
            FastScroller.this.setBubbleAndHandlePosition((float)FastScroller.this.height * proportion);
        }
    };

    public FastScroller(Context context) {
        super(context);
        this.init();
    }

    public FastScroller(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FastScroller(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setClipChildren(false);
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        this.recyclerView.addOnScrollListener(this.onScrollListener);
        this.recyclerView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                FastScroller.this.layoutManager = FastScroller.this.recyclerView.getLayoutManager();
            }
        });
        if (recyclerView.getAdapter() instanceof BubbleTextCreator) {
            this.bubbleTextCreator = (BubbleTextCreator)recyclerView.getAdapter();
        }
        if (recyclerView.getAdapter() instanceof OnScrollStateChangeListener) {
            this.addOnScrollStateChangeListener((OnScrollStateChangeListener)recyclerView.getAdapter());
        }
        this.recyclerView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                FastScroller.this.recyclerView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                if (FastScroller.this.bubble == null || FastScroller.this.handle.isSelected()) {
                    return true;
                }
                int verticalScrollOffset = FastScroller.this.recyclerView.computeVerticalScrollOffset();
                int verticalScrollRange = FastScroller.this.computeVerticalScrollRange();
                float proportion = (float)verticalScrollOffset / ((float)verticalScrollRange - (float)FastScroller.this.height);
                FastScroller.this.setBubbleAndHandlePosition((float)FastScroller.this.height * proportion);
                return true;
            }
        });
    }

    public void addOnScrollStateChangeListener(OnScrollStateChangeListener stateChangeListener) {
        if (stateChangeListener != null && !this.scrollStateChangeListeners.contains(stateChangeListener)) {
            this.scrollStateChangeListeners.add(stateChangeListener);
        }
    }

    public void removeOnScrollStateChangeListener(OnScrollStateChangeListener stateChangeListener) {
        this.scrollStateChangeListeners.remove(stateChangeListener);
    }

    private void notifyScrollStateChange(boolean scrolling) {
        for (OnScrollStateChangeListener stateChangeListener : this.scrollStateChangeListeners) {
            stateChangeListener.onFastScrollerStateChange(scrolling);
        }
    }

    public void setViewsToUse(@LayoutRes int layoutResId, @IdRes int bubbleResId, @IdRes int handleResId) {
        if (this.bubble != null) {
            return;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        inflater.inflate(layoutResId, (ViewGroup)this, true);
        this.bubble = (TextView)this.findViewById(bubbleResId);
        if (this.bubble != null) {
            this.bubble.setVisibility(4);
        }
        this.handle = (ImageView)this.findViewById(handleResId);
    }

    public void setViewsToUse(@LayoutRes int layoutResId, @IdRes int bubbleResId, @IdRes int handleResId, int accentColor) {
        this.setViewsToUse(layoutResId, bubbleResId, handleResId);
        this.setBubbleAndHandleColor(accentColor);
    }

    private void setBubbleAndHandleColor(int accentColor) {
        GradientDrawable bubbleDrawable = Build.VERSION.SDK_INT >= 21 ? (GradientDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_bubble, null) : (GradientDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_bubble);
        assert (bubbleDrawable != null);
        bubbleDrawable.setColor(accentColor);
        if (Build.VERSION.SDK_INT >= 16) {
            this.bubble.setBackground((Drawable)bubbleDrawable);
        } else {
            this.bubble.setBackgroundDrawable((Drawable)bubbleDrawable);
        }
        try {
            StateListDrawable stateListDrawable = Build.VERSION.SDK_INT >= 21 ? (StateListDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_handle, null) : (StateListDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_handle);
            Method getStateDrawable = StateListDrawable.class.getMethod("getStateDrawable", Integer.TYPE);
            GradientDrawable handleDrawable = (GradientDrawable)getStateDrawable.invoke((Object)stateListDrawable, 0);
            handleDrawable.setColor(accentColor);
            this.handle.setImageDrawable((Drawable)stateListDrawable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = h;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: {
                if (event.getX() < this.handle.getX() - (float)ViewCompat.getPaddingStart((View)this.handle)) {
                    return false;
                }
                if (this.currentAnimator != null) {
                    this.currentAnimator.cancel();
                }
                this.handle.setSelected(true);
                this.notifyScrollStateChange(true);
                this.showBubble();
            }
            case 2: {
                float y = event.getY();
                this.setBubbleAndHandlePosition(y);
                this.setRecyclerViewPosition(y);
                return true;
            }
            case 1: 
            case 3: {
                this.handle.setSelected(false);
                this.notifyScrollStateChange(false);
                this.hideBubble();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.recyclerView != null) {
            this.recyclerView.removeOnScrollListener(this.onScrollListener);
        }
    }

    private void setRecyclerViewPosition(float y) {
        if (this.recyclerView != null) {
            int itemCount = this.recyclerView.getAdapter().getItemCount();
            float proportion = this.handle.getY() == 0.0f ? 0.0f : (this.handle.getY() + (float)this.handle.getHeight() >= (float)(this.height - 5) ? 1.0f : y / (float)this.height);
            int targetPos = FastScroller.getValueInRange(0, itemCount - 1, (int)(proportion * (float)itemCount));
            if (this.layoutManager instanceof StaggeredGridLayoutManager) {
                ((StaggeredGridLayoutManager)this.layoutManager).scrollToPositionWithOffset(targetPos, 0);
            } else {
                ((LinearLayoutManager)this.layoutManager).scrollToPositionWithOffset(targetPos, 0);
            }
            if (this.bubble != null) {
                String bubbleText = this.bubbleTextCreator.onCreateBubbleText(targetPos);
                if (bubbleText != null) {
                    this.bubble.setVisibility(0);
                    this.bubble.setText((CharSequence)bubbleText);
                } else {
                    this.bubble.setVisibility(8);
                }
            }
        }
    }

    private static int getValueInRange(int min, int max, int value) {
        int minimum = Math.max(min, value);
        return Math.min(minimum, max);
    }

    private void setBubbleAndHandlePosition(float y) {
        int handleHeight = this.handle.getHeight();
        this.handle.setY((float)FastScroller.getValueInRange(0, this.height - handleHeight, (int)(y - (float)(handleHeight / 2))));
        if (this.bubble != null) {
            int bubbleHeight = this.bubble.getHeight();
            this.bubble.setY((float)FastScroller.getValueInRange(0, this.height - bubbleHeight - handleHeight / 2, (int)(y - (float)bubbleHeight)));
        }
    }

    private void showBubble() {
        if (this.bubble != null && this.bubble.getVisibility() != 0) {
            this.bubble.setVisibility(0);
            if (this.currentAnimator != null) {
                this.currentAnimator.cancel();
            }
            this.currentAnimator = ObjectAnimator.ofFloat((Object)this.bubble, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(300L);
            this.currentAnimator.start();
        }
    }

    private void hideBubble() {
        if (this.bubble == null) {
            return;
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        this.currentAnimator = ObjectAnimator.ofFloat((Object)this.bubble, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(300L);
        this.currentAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FastScroller.this.bubble.setVisibility(4);
                FastScroller.this.currentAnimator = null;
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                FastScroller.this.bubble.setVisibility(4);
                FastScroller.this.currentAnimator = null;
            }
        });
        this.currentAnimator.start();
    }

    public static interface OnScrollStateChangeListener {
        public void onFastScrollerStateChange(boolean var1);
    }

    public static interface BubbleTextCreator {
        public String onCreateBubbleText(int var1);
    }
}

