/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import eu.davidea.flexibleadapter.SelectableAdapter;
import eu.davidea.flexibleadapter.utils.Utils;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public abstract class AnimatorAdapter
extends SelectableAdapter {
    protected static final String TAG = AnimatorAdapter.class.getSimpleName();
    private Interpolator mInterpolator = new LinearInterpolator();
    private AnimatorAdapterDataObserver mAnimatorNotifierObserver;
    private boolean mEntryStep = true;
    private final SparseArray<Animator> mAnimators = new SparseArray();
    private int mLastAnimatedPosition = -1;
    private int mMaxChildViews = -1;
    private EnumSet<AnimatorEnum> animatorsUsed = EnumSet.noneOf(AnimatorEnum.class);
    private boolean isReverseEnabled = false;
    private boolean shouldAnimate = false;
    private boolean onlyEntryAnimation = false;
    private boolean isFastScroll = false;
    private boolean animateFromObserver = false;
    private long mInitialDelay = 0L;
    private long mStepDelay = 100L;
    private long mDuration = 300L;

    public AnimatorAdapter(boolean stableIds) {
        if (stableIds && DEBUG) {
            Log.i((String)TAG, (String)"Setting StableIds");
        }
        this.setHasStableIds(stableIds);
        this.mAnimatorNotifierObserver = new AnimatorAdapterDataObserver();
        this.registerAdapterDataObserver(this.mAnimatorNotifierObserver);
    }

    void setAnimate(boolean animate) {
        this.animateFromObserver = animate;
    }

    public AnimatorAdapter setAnimationInitialDelay(long initialDelay) {
        this.mInitialDelay = initialDelay;
        return this;
    }

    public AnimatorAdapter setAnimationDelay(@IntRange(from=0L) long delay) {
        this.mStepDelay = delay;
        return this;
    }

    public AnimatorAdapter setAnimationEntryStep(boolean entryStep) {
        this.mEntryStep = entryStep;
        return this;
    }

    public AnimatorAdapter setAnimationDuration(@IntRange(from=1L) long duration) {
        this.mDuration = duration;
        return this;
    }

    public AnimatorAdapter setAnimationInterpolator(@NonNull Interpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public AnimatorAdapter setAnimationStartPosition(@IntRange(from=0L) int start) {
        this.mLastAnimatedPosition = start;
        return this;
    }

    public AnimatorAdapter setAnimationOnScrolling(boolean enabled) {
        if (enabled) {
            this.onlyEntryAnimation = false;
        }
        this.shouldAnimate = enabled;
        return this;
    }

    public boolean isAnimationOnScrollingEnabled() {
        return this.shouldAnimate;
    }

    public AnimatorAdapter setAnimationOnReverseScrolling(boolean enabled) {
        this.isReverseEnabled = enabled;
        return this;
    }

    public boolean isAnimationOnReverseScrolling() {
        return this.isReverseEnabled;
    }

    public AnimatorAdapter setOnlyEntryAnimation(boolean enabled) {
        if (enabled) {
            this.shouldAnimate = true;
        }
        this.onlyEntryAnimation = enabled;
        return this;
    }

    public boolean isOnlyEntryAnimation() {
        return this.onlyEntryAnimation;
    }

    @Override
    public void onFastScrollerStateChange(boolean scrolling) {
        super.onFastScrollerStateChange(scrolling);
        this.isFastScroll = scrolling;
    }

    @CallSuper
    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        this.animateView(holder, position);
    }

    @Deprecated
    public List<Animator> getAnimators(View itemView, int position, boolean isForward) {
        return new ArrayList<Animator>();
    }

    private void cancelExistingAnimation(int hashCode) {
        Animator animator = (Animator)this.mAnimators.get(hashCode);
        if (animator != null) {
            animator.end();
        }
    }

    protected void animateView(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof FlexibleViewHolder && this.shouldAnimate && !this.isFastScroll && !this.mAnimatorNotifierObserver.isPositionNotified() && (this.isReverseEnabled || position > this.mLastAnimatedPosition || position == 0 && this.mRecyclerView.getChildCount() == 0)) {
            int hashCode = holder.itemView.hashCode();
            this.cancelExistingAnimation(hashCode);
            ArrayList<Animator> animators = new ArrayList<Animator>();
            FlexibleViewHolder flexibleViewHolder = (FlexibleViewHolder)holder;
            flexibleViewHolder.scrollAnimators(animators, position, position > this.mLastAnimatedPosition);
            AnimatorSet set = new AnimatorSet();
            set.playTogether(animators);
            set.setInterpolator((TimeInterpolator)this.mInterpolator);
            set.setDuration(this.mDuration);
            set.addListener((Animator.AnimatorListener)new HelperAnimatorListener(hashCode));
            if (this.mEntryStep) {
                set.setStartDelay(this.calculateAnimationDelay2(position));
            }
            set.start();
            this.mAnimators.put(hashCode, (Object)set);
            if (DEBUG) {
                Log.d((String)TAG, (String)("Started Animation on position " + position));
            }
            if (this.onlyEntryAnimation && position >= this.mMaxChildViews) {
                this.shouldAnimate = false;
            }
        }
        this.mAnimatorNotifierObserver.clearNotified();
        this.mLastAnimatedPosition = position;
    }

    @Deprecated
    public final void animateView(View itemView, int position) {
        if (this.shouldAnimate && !this.isFastScroll && !this.mAnimatorNotifierObserver.isPositionNotified() && (this.isReverseEnabled || position > this.mLastAnimatedPosition || position == 0 && this.mRecyclerView.getChildCount() == 0)) {
            this.cancelExistingAnimation(itemView.hashCode());
            List<Animator> animators = this.getAnimators(itemView, position, position > this.mLastAnimatedPosition);
            ViewCompat.setAlpha((View)itemView, (float)0.0f);
            animators.add((Animator)ObjectAnimator.ofFloat((Object)itemView, (String)"alpha", (float[])new float[]{0.0f, 1.0f}));
            if (DEBUG) {
                Log.d((String)TAG, (String)("Started Deprecated Animation on position " + position));
            }
            AnimatorSet set = new AnimatorSet();
            set.playTogether(animators);
            set.setInterpolator((TimeInterpolator)this.mInterpolator);
            set.setDuration(this.mDuration);
            set.addListener((Animator.AnimatorListener)new HelperAnimatorListener(itemView.hashCode()));
            if (this.mEntryStep) {
                set.setStartDelay(this.calculateAnimationDelay2(position));
            }
            set.start();
            this.mAnimators.put(itemView.hashCode(), (Object)set);
            if (this.onlyEntryAnimation && this.mLastAnimatedPosition >= this.mMaxChildViews) {
                this.shouldAnimate = false;
            }
        }
        this.mAnimatorNotifierObserver.clearNotified();
        this.mLastAnimatedPosition = position;
    }

    private long calculateAnimationDelay1(int position) {
        int visibleItems;
        int firstVisiblePosition = Utils.findFirstCompletelyVisibleItemPosition(this.mRecyclerView.getLayoutManager());
        int lastVisiblePosition = Utils.findLastCompletelyVisibleItemPosition(this.mRecyclerView.getLayoutManager());
        if (this.mMaxChildViews < this.mRecyclerView.getChildCount()) {
            this.mMaxChildViews = this.mRecyclerView.getChildCount();
        }
        if (this.mLastAnimatedPosition > lastVisiblePosition) {
            lastVisiblePosition = this.mLastAnimatedPosition;
        }
        if (this.mLastAnimatedPosition > (visibleItems = lastVisiblePosition - firstVisiblePosition) || firstVisiblePosition > 1 && firstVisiblePosition <= this.mMaxChildViews) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Reset AnimationDelay on position " + position));
            }
            return 0L;
        }
        return this.mInitialDelay += this.mStepDelay;
    }

    private long calculateAnimationDelay2(int position) {
        long delay;
        int firstVisiblePosition = Utils.findFirstCompletelyVisibleItemPosition(this.mRecyclerView.getLayoutManager());
        int lastVisiblePosition = Utils.findLastCompletelyVisibleItemPosition(this.mRecyclerView.getLayoutManager());
        if (this.mLastAnimatedPosition > lastVisiblePosition) {
            lastVisiblePosition = this.mLastAnimatedPosition;
        }
        int numberOfItemsOnScreen = lastVisiblePosition - firstVisiblePosition;
        int numberOfAnimatedItems = position - 1;
        if (this.mMaxChildViews < this.mRecyclerView.getChildCount()) {
            this.mMaxChildViews = this.mRecyclerView.getChildCount();
        }
        if (numberOfItemsOnScreen == 0 || numberOfItemsOnScreen < numberOfAnimatedItems || firstVisiblePosition > 1 && firstVisiblePosition <= this.mMaxChildViews || position > this.mMaxChildViews && firstVisiblePosition == -1 && this.mRecyclerView.getChildCount() == 0) {
            delay = this.mStepDelay;
            if (numberOfItemsOnScreen <= 1) {
                delay += this.mInitialDelay;
            } else {
                this.mInitialDelay = 0L;
            }
            if (this.mRecyclerView.getLayoutManager() instanceof GridLayoutManager) {
                int numColumns = ((GridLayoutManager)this.mRecyclerView.getLayoutManager()).getSpanCount();
                delay = this.mInitialDelay + this.mStepDelay * (long)(position % numColumns);
            }
        } else {
            delay = this.mInitialDelay + (long)position * this.mStepDelay;
        }
        return delay;
    }

    @Deprecated
    private void addAlphaAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float alphaFrom) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.ALPHA)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaFrom, 1.0f}));
        this.animatorsUsed.add(AnimatorEnum.ALPHA);
    }

    @Deprecated
    public void addSlideInFromLeftAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float percent) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)(-this.mRecyclerView.getLayoutManager().getWidth()) * percent, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_LEFT);
    }

    @Deprecated
    public void addSlideInFromRightAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float percent) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)this.mRecyclerView.getLayoutManager().getWidth() * percent, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_RIGHT);
    }

    @Deprecated
    public void addSlideInFromTopAnimator(@NonNull List<Animator> animators, @NonNull View view) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{-this.mRecyclerView.getMeasuredHeight() >> 1, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_TOP);
    }

    @Deprecated
    public void addSlideInFromBottomAnimator(@NonNull List<Animator> animators, @NonNull View view) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{this.mRecyclerView.getMeasuredHeight() >> 1, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_BOTTOM);
    }

    @Deprecated
    public void addScaleInAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float scaleFrom) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SCALE)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scaleFrom, 1.0f}));
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scaleFrom, 1.0f}));
        this.animatorsUsed.add(AnimatorEnum.SCALE);
    }

    private class HelperAnimatorListener
    implements Animator.AnimatorListener {
        int key;

        HelperAnimatorListener(int key) {
            this.key = key;
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimatorAdapter.this.mAnimators.remove(this.key);
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private class AnimatorAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private boolean notified;
        private Handler mAnimatorHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (SelectableAdapter.DEBUG) {
                    Log.v((String)TAG, (String)"Clear notified for binding Animations");
                }
                AnimatorAdapterDataObserver.this.notified = false;
                return true;
            }
        });

        private AnimatorAdapterDataObserver() {
        }

        public boolean isPositionNotified() {
            return this.notified;
        }

        public void clearNotified() {
            if (this.notified) {
                this.mAnimatorHandler.removeCallbacksAndMessages(null);
                this.mAnimatorHandler.sendMessageDelayed(Message.obtain((Handler)this.mAnimatorHandler), 200L);
            }
        }

        private void markNotified() {
            this.notified = !AnimatorAdapter.this.animateFromObserver;
        }

        public void onChanged() {
            this.markNotified();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.markNotified();
        }
    }

    private static enum AnimatorEnum {
        ALPHA,
        SLIDE_IN_LEFT,
        SLIDE_IN_RIGHT,
        SLIDE_IN_BOTTOM,
        SLIDE_IN_TOP,
        SCALE;

    }
}

