/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.ISectionable;
import eu.davidea.flexibleadapter.utils.Utils;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int mSectionOffset;
    private boolean mDrawOver = false;
    private boolean withOffset = false;
    private static final int[] ATTRS = new int[]{16843284};

    public DividerItemDecoration(Context context) {
        TypedArray styledAttributes = context.obtainStyledAttributes(ATTRS);
        this.mDivider = styledAttributes.getDrawable(0);
        styledAttributes.recycle();
    }

    public DividerItemDecoration(@NonNull Context context, @DrawableRes int resId) {
        this(context, resId, 0);
    }

    public DividerItemDecoration(@NonNull Context context, @DrawableRes int resId, @IntRange(from=0L) int sectionOffset) {
        if (resId > 0) {
            this.mDivider = ContextCompat.getDrawable((Context)context, (int)resId);
        }
        this.mSectionOffset = (int)(context.getResources().getDisplayMetrics().density * (float)sectionOffset);
    }

    public DividerItemDecoration withDrawOver(boolean drawOver) {
        this.mDrawOver = drawOver;
        return this;
    }

    public DividerItemDecoration setDrawOver(boolean drawOver) {
        return this.withDrawOver(drawOver);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider != null && !this.mDrawOver) {
            this.draw(c, parent);
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider != null && this.mDrawOver) {
            this.draw(c, parent);
        }
    }

    private void draw(Canvas c, RecyclerView parent) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin + Math.round(ViewCompat.getTranslationY((View)child));
            int bottom = top + this.mDivider.getIntrinsicHeight() + 1;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    @Deprecated
    public void setSectionGapWidth(@IntRange(from=0L) int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException("Invalid section gap width [<0]: " + gap);
        }
        this.mSectionOffset = gap;
    }

    public DividerItemDecoration withOffset(boolean withOffset) {
        this.withOffset = withOffset;
        return this;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        int position;
        FlexibleAdapter flexibleAdapter;
        int offset;
        int n = offset = this.mDivider != null && this.withOffset ? this.mDivider.getIntrinsicHeight() : 0;
        if (this.mSectionOffset > 0 && recyclerView.getAdapter() instanceof FlexibleAdapter && (flexibleAdapter = (FlexibleAdapter)recyclerView.getAdapter()).getItem(position = recyclerView.getChildAdapterPosition(view)) instanceof ISectionable && (flexibleAdapter.isHeader(flexibleAdapter.getItem(position + 1)) || position >= recyclerView.getAdapter().getItemCount() - 1)) {
            offset += this.mSectionOffset;
        }
        if (Utils.getOrientation(recyclerView.getLayoutManager()) == 1) {
            outRect.set(0, 0, 0, offset);
        } else {
            outRect.set(0, 0, offset, 0);
        }
    }
}

