/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.content.Context;
import android.graphics.PointF;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import eu.davidea.flexibleadapter.utils.Utils;

public class TopSnappedSmoothScroller
extends LinearSmoothScroller {
    public static float MILLISECONDS_PER_INCH = 100.0f;
    private PointF vectorPosition = new PointF(0.0f, 0.0f);
    private RecyclerView.LayoutManager layoutManager;

    public TopSnappedSmoothScroller(Context context, RecyclerView.LayoutManager layoutManager) {
        super(context);
        this.layoutManager = layoutManager;
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        int direction;
        int firstChildPos = Utils.findFirstCompletelyVisibleItemPosition(this.layoutManager);
        int n = direction = targetPosition < firstChildPos ? -1 : 1;
        if (Utils.getOrientation(this.layoutManager) == 0) {
            this.vectorPosition.set((float)direction, 0.0f);
            return this.vectorPosition;
        }
        this.vectorPosition.set(0.0f, (float)direction);
        return this.vectorPosition;
    }

    protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
        return MILLISECONDS_PER_INCH / (float)displayMetrics.densityDpi;
    }

    protected int getVerticalSnapPreference() {
        return -1;
    }
}

