/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.support.annotation.CallSuper;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ActionMode;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.SelectableAdapter;

public class ActionModeHelper
implements ActionMode.Callback {
    public static final String TAG = ActionModeHelper.class.getSimpleName();
    private int defaultMode = 0;
    @MenuRes
    private int mCabMenu;
    private FlexibleAdapter mAdapter;
    private ActionMode.Callback mCallback;
    protected ActionMode mActionMode;

    public ActionModeHelper(@NonNull FlexibleAdapter adapter, @MenuRes int cabMenu) {
        this.mAdapter = adapter;
        this.mCabMenu = cabMenu;
    }

    public ActionModeHelper(@NonNull FlexibleAdapter adapter, @MenuRes int cabMenu, @NonNull ActionMode.Callback callback) {
        this(adapter, cabMenu);
        this.mCallback = callback;
    }

    public final ActionModeHelper withDefaultMode(int defaultMode) {
        if (defaultMode == 0 || defaultMode == 1) {
            this.defaultMode = defaultMode;
        }
        return this;
    }

    public ActionMode getActionMode() {
        return this.mActionMode;
    }

    public boolean onClick(int position) {
        if (position != -1) {
            this.toggleSelection(position);
            return true;
        }
        return false;
    }

    @NonNull
    public ActionMode onLongClick(AppCompatActivity activity, int position) {
        if (this.mActionMode == null) {
            this.mActionMode = activity.startSupportActionMode((ActionMode.Callback)this);
        }
        this.toggleSelection(position);
        return this.mActionMode;
    }

    public void toggleSelection(int position) {
        if (position >= 0 && (this.mAdapter.getMode() == 1 || this.mAdapter.getMode() == 2)) {
            this.mAdapter.toggleSelection(position);
        }
        if (this.mActionMode == null) {
            return;
        }
        int count = this.mAdapter.getSelectedItemCount();
        if (count == 0) {
            this.mActionMode.finish();
        } else {
            this.updateContextTitle(count);
        }
    }

    public void updateContextTitle(int count) {
        if (this.mActionMode != null) {
            this.mActionMode.setTitle((CharSequence)String.valueOf(count));
        }
    }

    public void restoreSelection(AppCompatActivity activity) {
        if (this.defaultMode == 0 && this.mAdapter.getSelectedItemCount() > 0 || this.defaultMode == 1 && this.mAdapter.getSelectedItemCount() > 1) {
            this.onLongClick(activity, -1);
        }
    }

    @CallSuper
    public boolean onCreateActionMode(ActionMode actionMode, Menu menu) {
        actionMode.getMenuInflater().inflate(this.mCabMenu, menu);
        if (SelectableAdapter.DEBUG) {
            Log.i((String)TAG, (String)"ActionMode is active!");
        }
        this.mAdapter.setMode(2);
        return this.mCallback == null || this.mCallback.onCreateActionMode(actionMode, menu);
    }

    @CallSuper
    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu) {
        return this.mCallback != null && this.mCallback.onPrepareActionMode(actionMode, menu);
    }

    @CallSuper
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem item) {
        boolean consumed = false;
        if (this.mCallback != null) {
            consumed = this.mCallback.onActionItemClicked(actionMode, item);
        }
        if (!consumed) {
            actionMode.finish();
        }
        return consumed;
    }

    @CallSuper
    public void onDestroyActionMode(ActionMode actionMode) {
        if (SelectableAdapter.DEBUG) {
            Log.i((String)TAG, (String)("ActionMode is about to be destroyed! New mode will be " + this.defaultMode));
        }
        this.mAdapter.setMode(this.defaultMode);
        this.mAdapter.clearSelection();
        this.mActionMode = null;
        if (this.mCallback != null) {
            this.mCallback.onDestroyActionMode(actionMode);
        }
    }

    public boolean destroyActionModeIfCan() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            return true;
        }
        return false;
    }
}

