/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import java.util.List;

public class AnimatorHelper {
    protected static final String TAG = AnimatorHelper.class.getSimpleName();

    public static void alphaAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float alphaFrom) {
        ViewCompat.setAlpha((View)view, (float)0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaFrom, 1.0f}));
    }

    public static void slideInFromLeftAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView, @FloatRange(from=0.0, to=1.0) float percent) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)(-recyclerView.getLayoutManager().getWidth()) * percent, 0.0f}));
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)"Added LEFT Animator");
        }
    }

    public static void slideInFromRightAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView, @FloatRange(from=0.0, to=1.0) float percent) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)recyclerView.getLayoutManager().getWidth() * percent, 0.0f}));
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)"Added RIGHT Animator");
        }
    }

    public static void slideInFromTopAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{-recyclerView.getMeasuredHeight() >> 1, 0.0f}));
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)"Added TOP Animator");
        }
    }

    public static void slideInFromBottomAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{recyclerView.getMeasuredHeight() >> 1, 0.0f}));
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)"Added BOTTOM Animator");
        }
    }

    public static void scaleAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float scaleFrom) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scaleFrom, 1.0f}));
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scaleFrom, 1.0f}));
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)"Added SCALE Animator");
        }
    }
}

