/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.animation.Animator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.IHeader;
import eu.davidea.flexibleadapter.utils.Utils;
import eu.davidea.viewholders.FlexibleViewHolder;

public class StickyHeaderHelper
extends RecyclerView.OnScrollListener {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    private FlexibleAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private ViewGroup mStickyHolderLayout;
    private FlexibleViewHolder mStickyHeaderViewHolder;
    private FlexibleAdapter.OnStickyHeaderChangeListener mStickyHeaderChangeListener;
    private int mHeaderPosition = -1;

    public StickyHeaderHelper(FlexibleAdapter adapter, FlexibleAdapter.OnStickyHeaderChangeListener stickyHeaderChangeListener) {
        this.mAdapter = adapter;
        this.mStickyHeaderChangeListener = stickyHeaderChangeListener;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        this.updateOrClearHeader(false);
    }

    public boolean isAttachedToRecyclerView() {
        return this.mRecyclerView != null;
    }

    public void attachToRecyclerView(RecyclerView parent) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            this.clearHeader();
        }
        this.mRecyclerView = parent;
        if (this.mRecyclerView != null) {
            this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
            this.mRecyclerView.post(new Runnable(){

                @Override
                public void run() {
                    StickyHeaderHelper.this.initStickyHeadersHolder();
                }
            });
        }
    }

    public void detachFromRecyclerView(RecyclerView parent) {
        if (this.mRecyclerView == parent) {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            this.mRecyclerView = null;
            this.mStickyHolderLayout.animate().setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    StickyHeaderHelper.this.clearHeader();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mStickyHolderLayout.animate().alpha(0.0f).start();
            if (FlexibleAdapter.DEBUG) {
                Log.i((String)TAG, (String)"StickyHolderLayout detached");
            }
        }
    }

    private void initStickyHeadersHolder() {
        this.mStickyHolderLayout = this.mAdapter.getStickySectionHeadersHolder();
        if (this.mStickyHolderLayout != null) {
            if (this.mStickyHolderLayout.getLayoutParams() == null) {
                throw new IllegalStateException("The ViewGroup provided, doesn't have LayoutParams correctly set, please initialize the ViewGroup accordingly");
            }
            this.mStickyHolderLayout.setClipToPadding(false);
            this.mStickyHolderLayout.setAlpha(0.0f);
            this.updateOrClearHeader(false);
            this.mStickyHolderLayout.animate().alpha(1.0f).start();
            if (FlexibleAdapter.DEBUG) {
                Log.i((String)TAG, (String)"StickyHolderLayout initialized");
            }
        } else {
            Log.w((String)TAG, (String)"WARNING! ViewGroup for Sticky Headers unspecified! You must include @layout/sticky_header_layout or implement FlexibleAdapter.getStickySectionHeadersHolder() method");
        }
    }

    public boolean hasStickyHeaderTranslated(int position) {
        RecyclerView.ViewHolder vh = this.mRecyclerView.findViewHolderForAdapterPosition(position);
        return vh != null && (vh.itemView.getX() < 0.0f || vh.itemView.getY() < 0.0f);
    }

    private void onStickyHeaderChange(int sectionIndex) {
        if (this.mStickyHeaderChangeListener != null) {
            this.mStickyHeaderChangeListener.onStickyHeaderChange(sectionIndex);
        }
    }

    public void updateOrClearHeader(boolean updateHeaderContent) {
        if (this.mStickyHolderLayout == null || this.mAdapter.hasSearchText() || this.mRecyclerView == null || this.mRecyclerView.getChildCount() == 0) {
            this.clearHeader();
            return;
        }
        int firstHeaderPosition = this.getHeaderPosition(-1);
        if (firstHeaderPosition >= 0 && firstHeaderPosition < this.mAdapter.getItemCount()) {
            this.updateHeader(firstHeaderPosition, updateHeaderContent);
        } else {
            this.clearHeader();
        }
    }

    private void updateHeader(int headerPosition, boolean updateHeaderContent) {
        if (this.mHeaderPosition != headerPosition) {
            this.mHeaderPosition = headerPosition;
            FlexibleViewHolder holder = this.getHeaderViewHolder(headerPosition);
            if (FlexibleAdapter.DEBUG) {
                Log.d((String)TAG, (String)("swapHeader newHeaderPosition=" + this.mHeaderPosition));
            }
            this.swapHeader(holder);
        } else if (updateHeaderContent && this.mStickyHeaderViewHolder != null) {
            this.mAdapter.onBindViewHolder(this.mStickyHeaderViewHolder, this.mHeaderPosition);
            this.ensureHeaderParent();
        }
        this.translateHeader();
    }

    private void translateHeader() {
        if (this.mStickyHeaderViewHolder == null) {
            return;
        }
        int headerOffsetX = 0;
        int headerOffsetY = 0;
        for (int i = 0; i < this.mRecyclerView.getChildCount(); ++i) {
            int adapterPos;
            int nextHeaderPosition;
            View nextChild = this.mRecyclerView.getChildAt(i);
            if (nextChild == null || this.mHeaderPosition == (nextHeaderPosition = this.getHeaderPosition(adapterPos = this.mRecyclerView.getChildAdapterPosition(nextChild)))) continue;
            if (Utils.getOrientation(this.mRecyclerView.getLayoutManager()) == 0) {
                if (nextChild.getLeft() <= 0) continue;
                int headerWidth = this.mStickyHolderLayout.getMeasuredWidth();
                headerOffsetX = Math.min(nextChild.getLeft() - headerWidth, 0);
                if (headerOffsetX >= 0) continue;
                break;
            }
            if (nextChild.getTop() <= 0) continue;
            int headerHeight = this.mStickyHolderLayout.getMeasuredHeight();
            headerOffsetY = Math.min(nextChild.getTop() - headerHeight, 0);
            if (headerOffsetY < 0) break;
        }
        this.mStickyHolderLayout.setTranslationX((float)headerOffsetX);
        this.mStickyHolderLayout.setTranslationY((float)headerOffsetY);
    }

    private void swapHeader(FlexibleViewHolder newHeader) {
        if (this.mStickyHeaderViewHolder != null) {
            this.resetHeader(this.mStickyHeaderViewHolder);
        }
        this.mStickyHeaderViewHolder = newHeader;
        if (this.mStickyHeaderViewHolder != null) {
            this.mStickyHeaderViewHolder.setIsRecyclable(false);
            this.ensureHeaderParent();
        }
        this.onStickyHeaderChange(this.mHeaderPosition);
    }

    private void ensureHeaderParent() {
        View view = this.mStickyHeaderViewHolder.getContentView();
        this.mStickyHeaderViewHolder.itemView.getLayoutParams().width = view.getMeasuredWidth();
        this.mStickyHeaderViewHolder.itemView.getLayoutParams().height = view.getMeasuredHeight();
        ViewGroup.LayoutParams params = this.mStickyHolderLayout.getLayoutParams();
        params.width = view.getLayoutParams().width;
        params.height = view.getLayoutParams().height;
        StickyHeaderHelper.removeViewFromParent(view);
        this.mStickyHolderLayout.setClipToPadding(false);
        this.mStickyHolderLayout.addView(view);
    }

    public void clearHeader() {
        if (this.mStickyHeaderViewHolder != null) {
            if (FlexibleAdapter.DEBUG) {
                Log.d((String)TAG, (String)"clearHeader");
            }
            this.resetHeader(this.mStickyHeaderViewHolder);
            this.mStickyHolderLayout.setAlpha(1.0f);
            this.mStickyHeaderViewHolder = null;
            this.mHeaderPosition = -1;
            this.onStickyHeaderChange(this.mHeaderPosition);
        }
    }

    private void resetHeader(FlexibleViewHolder header) {
        View view = header.getContentView();
        StickyHeaderHelper.removeViewFromParent(view);
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
        this.mStickyHeaderViewHolder.itemView.setVisibility(0);
        if (!header.itemView.equals(view)) {
            ((ViewGroup)header.itemView).addView(view);
        }
        header.setIsRecyclable(true);
    }

    private static void removeViewFromParent(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(view);
        }
    }

    private int getHeaderPosition(int adapterPosHere) {
        if (adapterPosHere == -1 && (adapterPosHere = this.mRecyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager ? ((StaggeredGridLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPositions(null)[0] : ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPosition()) == 0 && !this.hasStickyHeaderTranslated(0)) {
            return -1;
        }
        IHeader header = this.mAdapter.getSectionHeader(adapterPosHere);
        if (header == null || this.mAdapter.isExpandable(header) && !this.mAdapter.isExpanded(header)) {
            return -1;
        }
        return this.mAdapter.getGlobalPositionOf(header);
    }

    private FlexibleViewHolder getHeaderViewHolder(int position) {
        FlexibleViewHolder holder = (FlexibleViewHolder)this.mRecyclerView.findViewHolderForAdapterPosition(position);
        if (holder == null) {
            int heightSpec;
            int widthSpec;
            holder = (FlexibleViewHolder)this.mAdapter.createViewHolder((ViewGroup)this.mRecyclerView, this.mAdapter.getItemViewType(position));
            this.mAdapter.bindViewHolder(holder, position);
            holder.setBackupPosition(position);
            if (Utils.getOrientation(this.mRecyclerView.getLayoutManager()) == 1) {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getWidth(), (int)0x40000000);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getHeight(), (int)0);
            } else {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getWidth(), (int)0);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getHeight(), (int)0x40000000);
            }
            View headerView = holder.getContentView();
            int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(this.mRecyclerView.getPaddingLeft() + this.mRecyclerView.getPaddingRight()), (int)headerView.getLayoutParams().width);
            int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.mRecyclerView.getPaddingTop() + this.mRecyclerView.getPaddingBottom()), (int)headerView.getLayoutParams().height);
            headerView.measure(childWidth, childHeight);
            headerView.layout(0, 0, headerView.getMeasuredWidth(), headerView.getMeasuredHeight());
        }
        return holder;
    }
}

