/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.widget.Snackbar;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class UndoHelper
extends Snackbar.Callback {
    public static final int UNDO_TIMEOUT = 5000;
    public static final int ACTION_REMOVE = 0;
    public static final int ACTION_UPDATE = 1;
    private int mAction = 0;
    private List<Integer> mPositions = null;
    private Object mPayload = null;
    private FlexibleAdapter mAdapter;
    private OnActionListener mActionListener;
    private OnUndoListener mUndoListener;

    public UndoHelper(FlexibleAdapter adapter, OnUndoListener undoListener) {
        this.mAdapter = adapter;
        this.mUndoListener = undoListener;
        adapter.setPermanentDelete(false);
    }

    public UndoHelper withPayload(Object payload) {
        this.mPayload = payload;
        return this;
    }

    public UndoHelper withAction(int action, @NonNull OnActionListener actionListener) {
        this.mAction = action;
        this.mActionListener = actionListener;
        return this;
    }

    public Snackbar remove(List<Integer> positions, @NonNull View mainView, @StringRes int messageStringResId, @StringRes int actionStringResId, @IntRange(from=0L) int undoTime) {
        Context context = mainView.getContext();
        return this.remove(positions, mainView, context.getString(messageStringResId), context.getString(actionStringResId), undoTime);
    }

    public Snackbar remove(List<Integer> positions, @NonNull View mainView, CharSequence message, CharSequence actionText, @IntRange(from=0L) int undoTime) {
        this.mPositions = positions;
        if (!this.mAdapter.isPermanentDelete()) {
            Snackbar snackbar = Snackbar.make((View)mainView, (CharSequence)message, (int)(undoTime + 400)).setCallback((Snackbar.Callback)this).setAction(actionText, new View.OnClickListener(){

                public void onClick(View v) {
                    if (UndoHelper.this.mUndoListener != null) {
                        UndoHelper.this.mUndoListener.onUndoConfirmed(UndoHelper.this.mAction);
                    }
                }
            });
            snackbar.show();
            return snackbar;
        }
        Snackbar snackbar = Snackbar.make((View)mainView, (CharSequence)message, (int)undoTime).setCallback((Snackbar.Callback)this);
        snackbar.show();
        return snackbar;
    }

    public void onDismissed(Snackbar snackbar, int event) {
        if (this.mAdapter.isPermanentDelete()) {
            return;
        }
        switch (event) {
            case 1: {
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                if (this.mUndoListener != null) {
                    this.mUndoListener.onDeleteConfirmed(this.mAction);
                }
                this.mAdapter.emptyBin();
            }
        }
    }

    public void onShown(Snackbar snackbar) {
        boolean consumed = false;
        if (this.mActionListener != null) {
            consumed = this.mActionListener.onPreAction();
        }
        if (!consumed) {
            this.mAdapter.removeItems(this.mPositions, this.mPayload);
        }
        if (this.mActionListener != null) {
            this.mActionListener.onPostAction();
        }
        if (this.mAdapter.isPermanentDelete() && this.mUndoListener != null) {
            this.mUndoListener.onDeleteConfirmed(this.mAction);
        }
    }

    public static interface OnUndoListener {
        public void onUndoConfirmed(int var1);

        public void onDeleteConfirmed(int var1);
    }

    public static interface OnActionListener {
        public boolean onPreAction();

        public void onPostAction();
    }

    public static class SimpleActionListener
    implements OnActionListener {
        @Override
        public boolean onPreAction() {
            return false;
        }

        @Override
        public void onPostAction() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
    }
}

