/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.widget.TextView;
import java.util.Locale;

public final class Utils {
    public static final int INVALID_COLOR = -1;
    public static int colorAccent = -1;

    public static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean hasJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static void highlightText(@NonNull Context context, @NonNull TextView textView, String originalText, String constraint, @ColorInt int defColor) {
        int i;
        if (originalText == null) {
            originalText = "";
        }
        if (constraint == null) {
            constraint = "";
        }
        if ((i = originalText.toLowerCase(Locale.getDefault()).indexOf(constraint.toLowerCase(Locale.getDefault()))) != -1) {
            Spannable spanText = Spannable.Factory.getInstance().newSpannable((CharSequence)originalText);
            spanText.setSpan((Object)new ForegroundColorSpan(Utils.fetchAccentColor(context, defColor)), i, i + constraint.length(), 33);
            spanText.setSpan((Object)new StyleSpan(1), i, i + constraint.length(), 33);
            textView.setText((CharSequence)spanText, TextView.BufferType.SPANNABLE);
        } else {
            textView.setText((CharSequence)originalText, TextView.BufferType.NORMAL);
        }
    }

    public static void resetAccentColor() {
        colorAccent = -1;
    }

    @TargetApi(value=21)
    public static int fetchAccentColor(Context context, @ColorInt int defColor) {
        if (colorAccent == -1) {
            if (Utils.hasLollipop()) {
                TypedArray androidAttr = context.getTheme().obtainStyledAttributes(new int[]{16843829});
                colorAccent = androidAttr.getColor(0, defColor);
                androidAttr.recycle();
            } else {
                colorAccent = defColor;
            }
        }
        return colorAccent;
    }

    @Deprecated
    public static int getOrientation(RecyclerView recyclerView) {
        return Utils.getOrientation(recyclerView.getLayoutManager());
    }

    public static int getOrientation(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getOrientation();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        }
        return 0;
    }

    public static int findFirstCompletelyVisibleItemPosition(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPositions(null)[0];
        }
        return ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
    }

    public static int findLastCompletelyVisibleItemPosition(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).findLastCompletelyVisibleItemPositions(null)[0];
        }
        return ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
    }

    public static Activity scanForActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return Utils.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }
}

