/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.animation.Animator;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.viewholders.ContentViewHolder;
import java.util.List;

public abstract class FlexibleViewHolder
extends ContentViewHolder
implements View.OnClickListener,
View.OnLongClickListener,
View.OnTouchListener,
ItemTouchHelperCallback.ViewHolderCallback {
    private static final String TAG = FlexibleViewHolder.class.getSimpleName();
    protected final FlexibleAdapter mAdapter;
    private boolean mLongClickSkipped = false;
    private boolean alreadySelected = false;
    protected int mActionState = 0;

    public FlexibleViewHolder(View view, FlexibleAdapter adapter) {
        this(view, adapter, false);
    }

    public FlexibleViewHolder(View view, FlexibleAdapter adapter, boolean stickyHeader) {
        super(view, adapter, stickyHeader);
        this.mAdapter = adapter;
        this.getContentView().setOnClickListener((View.OnClickListener)this);
        this.getContentView().setOnLongClickListener((View.OnLongClickListener)this);
    }

    @CallSuper
    public void onClick(View view) {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isEnabled(position)) {
            return;
        }
        if (this.mAdapter.mItemClickListener != null && this.mActionState == 0) {
            if (FlexibleAdapter.DEBUG) {
                Log.v((String)TAG, (String)("onClick on position " + position + " mode=" + this.mAdapter.getMode()));
            }
            if (this.mAdapter.mItemClickListener.onItemClick(position) && (!this.mAdapter.isSelected(position) && this.itemView.isActivated() || this.mAdapter.isSelected(position) && !this.itemView.isActivated())) {
                this.toggleActivation();
            }
        }
    }

    @CallSuper
    public boolean onLongClick(View view) {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isEnabled(position)) {
            return false;
        }
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onLongClick on position " + position + " mode=" + this.mAdapter.getMode()));
        }
        if (this.mAdapter.mItemLongClickListener != null && !this.mAdapter.isLongPressDragEnabled()) {
            this.mAdapter.mItemLongClickListener.onItemLongClick(position);
            this.toggleActivation();
            return true;
        }
        this.mLongClickSkipped = true;
        return false;
    }

    public boolean onTouch(View view, MotionEvent event) {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isEnabled(position)) {
            return false;
        }
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onTouch with DragHandleView on position " + position + " mode=" + this.mAdapter.getMode()));
        }
        if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && this.mAdapter.isHandleDragEnabled()) {
            this.mAdapter.getItemTouchHelper().startDrag((RecyclerView.ViewHolder)this);
        }
        return false;
    }

    @CallSuper
    protected void setDragHandleView(@NonNull View view) {
        if (view != null) {
            view.setOnTouchListener((View.OnTouchListener)this);
        }
    }

    @CallSuper
    protected void toggleActivation() {
        this.itemView.setActivated(this.mAdapter.isSelected(this.getFlexibleAdapterPosition()));
        if (this.itemView.isActivated() && this.getActivationElevation() > 0.0f) {
            ViewCompat.setElevation((View)this.itemView, (float)this.getActivationElevation());
        } else if (this.getActivationElevation() > 0.0f) {
            ViewCompat.setElevation((View)this.itemView, (float)0.0f);
        }
    }

    public float getActivationElevation() {
        return 0.0f;
    }

    protected boolean shouldActivateViewWhileSwiping() {
        return false;
    }

    protected boolean shouldAddSelectionInActionMode() {
        return false;
    }

    public void scrollAnimators(@NonNull List<Animator> animators, int position, boolean isForward) {
    }

    @Override
    @CallSuper
    public void onActionStateChanged(int position, int actionState) {
        this.mActionState = actionState;
        this.alreadySelected = this.mAdapter.isSelected(position);
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onActionStateChanged position=" + position + " mode=" + this.mAdapter.getMode() + " actionState=" + (actionState == 1 ? "Swipe(1)" : "Drag(2)")));
        }
        if (actionState == 2) {
            if (!this.alreadySelected) {
                if ((this.mLongClickSkipped || this.mAdapter.getMode() == 2) && (this.shouldAddSelectionInActionMode() || this.mAdapter.getMode() != 2) && this.mAdapter.mItemLongClickListener != null && this.mAdapter.isSelectable(position)) {
                    this.mAdapter.mItemLongClickListener.onItemLongClick(position);
                    this.alreadySelected = true;
                }
                if (!this.alreadySelected) {
                    this.mAdapter.toggleSelection(position);
                }
            }
            if (!this.itemView.isActivated()) {
                this.toggleActivation();
            }
        } else if (actionState == 1 && this.shouldActivateViewWhileSwiping() && !this.alreadySelected) {
            this.mAdapter.toggleSelection(position);
            this.toggleActivation();
        }
    }

    @Override
    @CallSuper
    public void onItemReleased(int position) {
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onItemReleased position=" + position + " mode=" + this.mAdapter.getMode() + " actionState=" + (this.mActionState == 1 ? "Swipe(1)" : "Drag(2)")));
        }
        if (!this.alreadySelected) {
            if (this.shouldAddSelectionInActionMode() && this.mAdapter.getMode() == 2) {
                this.mAdapter.mItemLongClickListener.onItemLongClick(position);
                if (this.mAdapter.isSelected(position)) {
                    this.toggleActivation();
                }
            } else if (this.shouldActivateViewWhileSwiping() && this.itemView.isActivated()) {
                this.mAdapter.toggleSelection(position);
                this.toggleActivation();
            } else if (this.mActionState == 2) {
                this.mAdapter.toggleSelection(position);
                if (this.itemView.isActivated()) {
                    this.toggleActivation();
                }
            }
        }
        this.mLongClickSkipped = false;
        this.mActionState = 0;
    }

    @Override
    public boolean isDraggable() {
        Object item = this.mAdapter.getItem(this.getFlexibleAdapterPosition());
        return item != null && item.isDraggable();
    }

    @Override
    public boolean isSwipeable() {
        Object item = this.mAdapter.getItem(this.getFlexibleAdapterPosition());
        return item != null && item.isSwipeable();
    }

    @Override
    public View getFrontView() {
        return this.itemView;
    }

    @Override
    public View getRearLeftView() {
        return null;
    }

    @Override
    public View getRearRightView() {
        return null;
    }
}

