/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.fastscroller;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.view.View;

public class BubbleAnimator {
    protected ObjectAnimator animator;
    protected View bubble;
    protected long durationInMillis;
    private boolean isAnimating;

    public BubbleAnimator(View bubble, long durationInMillis) {
        this.bubble = bubble;
        this.durationInMillis = durationInMillis;
    }

    public void showBubble() {
        if (this.bubble == null) {
            return;
        }
        if (this.isAnimating) {
            this.animator.cancel();
        }
        if (this.bubble.getVisibility() != 0) {
            this.bubble.setVisibility(0);
            if (this.isAnimating) {
                this.animator.cancel();
            }
            this.animator = this.createShowAnimator(this.bubble);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    super.onAnimationCancel(animation);
                    BubbleAnimator.this.onShowAnimationStop(BubbleAnimator.this.bubble);
                    BubbleAnimator.this.isAnimating = false;
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    BubbleAnimator.this.onShowAnimationStop(BubbleAnimator.this.bubble);
                    BubbleAnimator.this.isAnimating = false;
                }
            });
            this.animator.start();
            this.isAnimating = true;
        }
    }

    public void hideBubble() {
        if (this.bubble == null) {
            return;
        }
        if (this.isAnimating) {
            this.animator.cancel();
        }
        this.animator = this.createHideAnimator(this.bubble);
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                BubbleAnimator.this.onHideAnimationStop(BubbleAnimator.this.bubble);
                BubbleAnimator.this.isAnimating = false;
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                BubbleAnimator.this.onHideAnimationStop(BubbleAnimator.this.bubble);
                BubbleAnimator.this.isAnimating = false;
            }
        });
        this.animator.start();
        this.isAnimating = true;
    }

    protected ObjectAnimator createShowAnimator(View bubble) {
        return ObjectAnimator.ofFloat((Object)bubble, (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(this.durationInMillis);
    }

    protected ObjectAnimator createHideAnimator(View bubble) {
        return ObjectAnimator.ofFloat((Object)bubble, (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration(this.durationInMillis);
    }

    protected void onShowAnimationStop(View bubble) {
    }

    protected void onHideAnimationStop(View bubble) {
        bubble.setVisibility(4);
    }
}

