/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.extractors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import technology.tabula.Line;
import technology.tabula.Page;
import technology.tabula.Rectangle;
import technology.tabula.Ruling;
import technology.tabula.Table;
import technology.tabula.TextChunk;
import technology.tabula.TextElement;
import technology.tabula.extractors.ExtractionAlgorithm;

public class BasicExtractionAlgorithm
implements ExtractionAlgorithm {
    private List<Ruling> verticalRulings = null;

    public BasicExtractionAlgorithm() {
    }

    public BasicExtractionAlgorithm(List<Ruling> verticalRulings) {
        this.verticalRulings = verticalRulings;
    }

    public List<Table> extract(Page page, List<Float> verticalRulingPositions) {
        ArrayList<Ruling> verticalRulings = new ArrayList<Ruling>(verticalRulingPositions.size());
        for (Float p : verticalRulingPositions) {
            verticalRulings.add(new Ruling(page.getTop(), p.floatValue(), 0.0f, (float)page.getHeight()));
        }
        this.verticalRulings = verticalRulings;
        return this.extract(page);
    }

    public List<Table> extract(Page page) {
        List<TextElement> textElements = page.getText();
        if (textElements.size() == 0) {
            return Arrays.asList(Table.empty());
        }
        List<TextChunk> textChunks = this.verticalRulings == null ? TextElement.mergeWords(page.getText()) : TextElement.mergeWords(page.getText(), this.verticalRulings);
        List<Line> lines = TextChunk.groupByLines(textChunks);
        List<Float> columns = null;
        if (this.verticalRulings != null) {
            Collections.sort(this.verticalRulings, new Comparator<Ruling>(){

                @Override
                public int compare(Ruling arg0, Ruling arg1) {
                    return Double.compare(arg0.getLeft(), arg1.getLeft());
                }
            });
            columns = new ArrayList<Float>(this.verticalRulings.size());
            for (Ruling vr : this.verticalRulings) {
                columns.add(Float.valueOf(vr.getLeft()));
            }
        } else {
            columns = BasicExtractionAlgorithm.columnPositions(lines);
        }
        Table table = new Table(this);
        table.setRect((double)page.getLeft(), (double)page.getTop(), page.getWidth(), page.getHeight());
        table.setPageNumber(page.getPageNumber());
        for (int i = 0; i < lines.size(); ++i) {
            Line line = lines.get(i);
            List<TextChunk> elements = line.getTextElements();
            Collections.sort(elements, new Comparator<TextChunk>(){

                @Override
                public int compare(TextChunk o1, TextChunk o2) {
                    return Float.compare(o1.getLeft(), o2.getLeft());
                }
            });
            for (TextChunk tc : elements) {
                int j;
                if (tc.isSameChar(Line.WHITE_SPACE_CHARS)) continue;
                boolean found = false;
                for (j = 0; j < columns.size(); ++j) {
                    if (!(tc.getLeft() <= columns.get(j).floatValue())) continue;
                    found = true;
                    break;
                }
                table.add(tc, i, found ? j : columns.size());
            }
        }
        return Arrays.asList(table);
    }

    @Override
    public String toString() {
        return "stream";
    }

    public static List<Float> columnPositions(List<Line> lines) {
        ArrayList<Rectangle> regions = new ArrayList<Rectangle>();
        for (TextChunk tc : lines.get(0).getTextElements()) {
            if (tc.isSameChar(Line.WHITE_SPACE_CHARS)) continue;
            Rectangle r = new Rectangle();
            r.setRect(tc);
            regions.add(r);
        }
        for (Line l : lines.subList(1, lines.size())) {
            ArrayList<TextChunk> lineTextElements = new ArrayList<TextChunk>();
            for (TextChunk tc : l.getTextElements()) {
                if (tc.isSameChar(Line.WHITE_SPACE_CHARS)) continue;
                lineTextElements.add(tc);
            }
            for (Rectangle cr : regions) {
                ArrayList<TextChunk> overlaps = new ArrayList<TextChunk>();
                for (TextChunk te : lineTextElements) {
                    if (!cr.horizontallyOverlaps(te)) continue;
                    overlaps.add(te);
                }
                for (TextChunk te : overlaps) {
                    cr.merge(te);
                }
                lineTextElements.removeAll(overlaps);
            }
            for (TextChunk te : lineTextElements) {
                Rectangle r = new Rectangle();
                r.setRect(te);
                regions.add(r);
            }
        }
        ArrayList<Float> rv = new ArrayList<Float>();
        for (Rectangle r : regions) {
            rv.add(Float.valueOf(r.getRight()));
        }
        Collections.sort(rv);
        return rv;
    }
}

