/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;

public final class TableSerializer
implements JsonSerializer<Table> {
    public static final TableSerializer INSTANCE = new TableSerializer();

    private TableSerializer() {
    }

    public JsonElement serialize(Table table, Type type, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        JsonArray data = new JsonArray();
        json.addProperty("extraction_method", table.getExtractionMethod());
        json.addProperty("page_number", (Number)table.getPageNumber());
        json.addProperty("top", (Number)Float.valueOf(table.getTop()));
        json.addProperty("left", (Number)Float.valueOf(table.getLeft()));
        json.addProperty("width", (Number)table.getWidth());
        json.addProperty("height", (Number)table.getHeight());
        json.addProperty("right", (Number)Float.valueOf(table.getRight()));
        json.addProperty("bottom", (Number)Float.valueOf(table.getBottom()));
        json.add("data", (JsonElement)data);
        for (List<RectangularTextContainer> tableRow : table.getRows()) {
            JsonArray jsonRow = new JsonArray();
            for (RectangularTextContainer textChunk : tableRow) {
                jsonRow.add(context.serialize((Object)textChunk));
            }
            data.add((JsonElement)jsonRow);
        }
        return json;
    }
}

