/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.vafer.jdependency;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import shadow.org.vafer.jdeb.shaded.commons.io.FilenameUtils;
import shadow.org.vafer.jdeb.shaded.commons.io.input.MessageDigestCalculatingInputStream;
import shadow.org.vafer.jdeb.shaded.objectweb.asm.ClassReader;
import shadow.org.vafer.jdependency.Clazz;
import shadow.org.vafer.jdependency.ClazzpathUnit;
import shadow.org.vafer.jdependency.asm.DependenciesClassAdapter;
import shadow.org.vafer.jdependency.utils.StreamUtils;

public final class Clazzpath {
    private final Set<ClazzpathUnit> units = new HashSet<ClazzpathUnit>();
    private final Map<String, Clazz> missing = new HashMap<String, Clazz>();
    private final Map<String, Clazz> clazzes = new HashMap<String, Clazz>();
    private final boolean versions;

    private static boolean isValidResourceName(String pName) {
        return pName != null && pName.endsWith(".class") && !pName.contains("-");
    }

    public Clazzpath() {
        this(false);
    }

    public Clazzpath(boolean pVersions) {
        this.versions = pVersions;
    }

    public boolean removeClazzpathUnit(ClazzpathUnit pUnit) {
        Set<Clazz> unitClazzes = pUnit.getClazzes();
        for (Clazz clazz : unitClazzes) {
            clazz.removeClazzpathUnit(pUnit);
            if (clazz.getClazzpathUnits().size() != 0) continue;
            this.clazzes.remove(clazz.toString());
        }
        return this.units.remove(pUnit);
    }

    public ClazzpathUnit addClazzpathUnit(File pFile) throws IOException {
        return this.addClazzpathUnit(pFile.toPath());
    }

    public ClazzpathUnit addClazzpathUnit(File pFile, String pId) throws IOException {
        return this.addClazzpathUnit(pFile.toPath(), pId);
    }

    public ClazzpathUnit addClazzpathUnit(Path pPath) throws IOException {
        return this.addClazzpathUnit(pPath, pPath.toString());
    }

    public ClazzpathUnit addClazzpathUnit(Path pPath, String pId) throws IOException {
        Path path = pPath.toAbsolutePath();
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return this.addClazzpathUnit(Files.newInputStream(path, new OpenOption[0]), pId);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            String prefix = FilenameUtils.separatorsToUnix(FilenameUtils.normalize(path.toString() + '/'));
            Iterable<Resource> resources = Files.walk(path, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> Clazzpath.isValidResourceName(p.getFileName().toString())).map(p -> new Resource(p.toString().substring(prefix.length()), (Path)p){
                final /* synthetic */ Path val$p;
                {
                    this.val$p = path;
                    super(pName);
                }

                @Override
                InputStream getInputStream() throws IOException {
                    return Files.newInputStream(this.val$p, new OpenOption[0]);
                }
            })::iterator;
            return this.addClazzpathUnit(resources, pId, true);
        }
        throw new IllegalArgumentException("neither file nor directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClazzpathUnit addClazzpathUnit(InputStream pInputStream, String pId) throws IOException {
        try (final JarInputStream inputStream = new JarInputStream(pInputStream);){
            Iterable<Resource> resources = StreamUtils.asStream(inputStream).map(e -> e.getName()).filter(name -> Clazzpath.isValidResourceName(name)).map(name -> new Resource((String)name){

                @Override
                InputStream getInputStream() throws IOException {
                    return inputStream;
                }
            })::iterator;
            ClazzpathUnit clazzpathUnit = this.addClazzpathUnit(resources, pId, false);
            return clazzpathUnit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClazzpathUnit addClazzpathUnit(Iterable<Resource> resources, String pId, boolean shouldCloseResourceStream) throws IOException {
        HashMap<String, Clazz> unitClazzes = new HashMap<String, Clazz>();
        HashMap<String, Clazz> unitDependencies = new HashMap<String, Clazz>();
        ClazzpathUnit unit = new ClazzpathUnit(pId, unitClazzes, unitDependencies);
        for (Resource resource : resources) {
            InputStream inputStream = resource.getInputStream();
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                MessageDigestCalculatingInputStream calculatingInputStream = new MessageDigestCalculatingInputStream(inputStream, digest);
                if (this.versions) {
                    inputStream = calculatingInputStream;
                }
                DependenciesClassAdapter v = new DependenciesClassAdapter();
                new ClassReader(inputStream).accept(v, 10);
                String clazzName = resource.name;
                Clazz clazz = this.getClazz(clazzName);
                if (clazz == null) {
                    clazz = this.missing.get(clazzName);
                    clazz = clazz != null ? this.missing.remove(clazzName) : new Clazz(clazzName);
                }
                String d = Base64.getEncoder().encodeToString(digest.digest());
                clazz.addClazzpathUnit(unit, d);
                this.clazzes.put(clazzName, clazz);
                unitClazzes.put(clazzName, clazz);
                Set<String> depNames = v.getDependencies();
                for (String depName : depNames) {
                    Clazz dep = this.getClazz(depName);
                    if (dep == null) {
                        dep = this.missing.get(depName);
                    }
                    if (dep == null) {
                        dep = new Clazz(depName);
                        this.missing.put(depName, dep);
                    }
                    if (dep == clazz) continue;
                    unitDependencies.put(depName, dep);
                    clazz.addDependency(dep);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            continue;
            finally {
                if (!shouldCloseResourceStream || inputStream == null) continue;
                inputStream.close();
            }
        }
        this.units.add(unit);
        return unit;
    }

    public Set<Clazz> getClazzes() {
        return new HashSet<Clazz>(this.clazzes.values());
    }

    public Set<Clazz> getClashedClazzes() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            if (clazz.getClazzpathUnits().size() <= 1) continue;
            all.add(clazz);
        }
        return all;
    }

    public Set<Clazz> getMissingClazzes() {
        return new HashSet<Clazz>(this.missing.values());
    }

    public Clazz getClazz(String pClazzName) {
        return this.clazzes.get(pClazzName);
    }

    public ClazzpathUnit[] getUnits() {
        return this.units.toArray(new ClazzpathUnit[this.units.size()]);
    }

    private static abstract class Resource {
        private static final int ext = ".class".length();
        public final String name;

        Resource(String pName) {
            int all = pName.length();
            this.name = FilenameUtils.separatorsToUnix(pName).substring(0, all - ext).replace('/', '.');
        }

        abstract InputStream getInputStream() throws IOException;
    }
}

