/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.events.TimerEvent;
import com.google.cloud.tools.jib.event.progress.ProgressEventHandler;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.gradle.extension.JibGradlePluginExtension;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.JavaContainerBuilderHelper;
import com.google.cloud.tools.jib.plugins.common.PluginExtensionLogger;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.cloud.tools.jib.plugins.common.ZipUtil;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLoggerBuilder;
import com.google.cloud.tools.jib.plugins.common.logging.ProgressDisplayGenerator;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.cloud.tools.jib.plugins.extension.NullExtension;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;

public class GradleProjectProperties
implements ProjectProperties {
    private static final String TOOL_NAME = "jib-gradle-plugin";
    static final String TOOL_VERSION = GradleProjectProperties.class.getPackage().getImplementationVersion();
    private static final String PLUGIN_NAME = "jib";
    private static final String JAR_PLUGIN_NAME = "'jar' task";
    private static final String MAIN_SOURCE_SET_NAME = "main";
    private static final Duration LOGGING_THREAD_SHUTDOWN_TIMEOUT = Duration.ofSeconds(1L);
    private final Project project;
    private final SingleThreadedExecutor singleThreadedExecutor = new SingleThreadedExecutor();
    private final ConsoleLogger consoleLogger;
    private final TempDirectoryProvider tempDirectoryProvider;
    private final Supplier<List<JibGradlePluginExtension<?>>> extensionLoader;
    private final String configurationName;

    public static GradleProjectProperties getForProject(Project project, Logger logger, TempDirectoryProvider tempDirectoryProvider, String configurationName) {
        Supplier<List<JibGradlePluginExtension<?>>> extensionLoader = () -> {
            ArrayList<JibGradlePluginExtension> extensions = new ArrayList<JibGradlePluginExtension>();
            for (JibGradlePluginExtension extension : ServiceLoader.load(JibGradlePluginExtension.class)) {
                extensions.add(extension);
            }
            return extensions;
        };
        return new GradleProjectProperties(project, logger, tempDirectoryProvider, extensionLoader, configurationName);
    }

    String getWarFilePath() {
        TaskProvider<Task> bootWarTask = TaskCommon.getBootWarTaskProvider(this.project);
        if (bootWarTask != null && ((Task)bootWarTask.get()).getEnabled()) {
            return ((Task)bootWarTask.get()).getOutputs().getFiles().getAsPath();
        }
        TaskProvider<Task> warTask = TaskCommon.getWarTaskProvider(this.project);
        return ((Task)((TaskProvider)Verify.verifyNotNull(warTask)).get()).getOutputs().getFiles().getAsPath();
    }

    private static boolean isProgressFooterEnabled(Project project) {
        if ("plain".equals(System.getProperty("jib.console"))) {
            return false;
        }
        switch (project.getGradle().getStartParameter().getConsoleOutput()) {
            case Plain: {
                return false;
            }
            case Auto: {
                return Os.isFamily((String)"windows") || !"dumb".equals(System.getenv("TERM"));
            }
        }
        return true;
    }

    @VisibleForTesting
    GradleProjectProperties(Project project, Logger logger, TempDirectoryProvider tempDirectoryProvider, Supplier<List<JibGradlePluginExtension<?>>> extensionLoader, String configurationName) {
        this.project = project;
        this.tempDirectoryProvider = tempDirectoryProvider;
        this.extensionLoader = extensionLoader;
        this.configurationName = configurationName;
        ConsoleLoggerBuilder consoleLoggerBuilder = (GradleProjectProperties.isProgressFooterEnabled(project) ? ConsoleLoggerBuilder.rich(this.singleThreadedExecutor, false) : ConsoleLoggerBuilder.plain(this.singleThreadedExecutor).progress(arg_0 -> ((Logger)logger).lifecycle(arg_0))).lifecycle(arg_0 -> ((Logger)logger).lifecycle(arg_0));
        if (logger.isDebugEnabled()) {
            consoleLoggerBuilder.debug(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        if (logger.isInfoEnabled()) {
            consoleLoggerBuilder.info(arg_0 -> ((Logger)logger).info(arg_0));
        }
        if (logger.isWarnEnabled()) {
            consoleLoggerBuilder.warn(arg_0 -> ((Logger)logger).warn(arg_0));
        }
        if (logger.isErrorEnabled()) {
            consoleLoggerBuilder.error(arg_0 -> ((Logger)logger).error(arg_0));
        }
        this.consoleLogger = consoleLoggerBuilder.build();
    }

    @Override
    public JibContainerBuilder createJibContainerBuilder(JavaContainerBuilder javaContainerBuilder, ContainerizingMode containerizingMode) {
        try {
            ConfigurableFileCollection projectDependencies = this.project.files(new Object[]{this.project.getConfigurations().getByName(this.configurationName).getResolvedConfiguration().getResolvedArtifacts().stream().filter(artifact -> artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier).map(ResolvedArtifact::getFile).collect(Collectors.toList())});
            if (this.isWarProject()) {
                String warFilePath = this.getWarFilePath();
                this.log(LogEvent.info("WAR project identified, creating WAR image from: " + warFilePath));
                Path explodedWarPath = this.tempDirectoryProvider.newDirectory();
                ZipUtil.unzip(Paths.get(warFilePath, new String[0]), explodedWarPath);
                return JavaContainerBuilderHelper.fromExplodedWar(javaContainerBuilder, explodedWarPath, projectDependencies.getFiles().stream().map(File::getName).collect(Collectors.toSet()));
            }
            SourceSet mainSourceSet = this.getMainSourceSet();
            FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs().filter(File::exists);
            Path resourcesOutputDirectory = mainSourceSet.getOutput().getResourcesDir().toPath();
            FileCollection allFiles = this.project.getConfigurations().getByName(this.configurationName).filter(File::exists);
            FileCollection nonProjectDependencies = allFiles.minus(classesOutputDirectories).minus((FileCollection)projectDependencies).filter(file -> !file.toPath().equals(resourcesOutputDirectory));
            FileCollection snapshotDependencies = nonProjectDependencies.filter(file -> file.getName().contains("SNAPSHOT"));
            FileCollection dependencies = nonProjectDependencies.minus(snapshotDependencies);
            javaContainerBuilder.addDependencies(dependencies.getFiles().stream().map(File::toPath).collect(Collectors.toList())).addSnapshotDependencies(snapshotDependencies.getFiles().stream().map(File::toPath).collect(Collectors.toList())).addProjectDependencies(projectDependencies.getFiles().stream().map(File::toPath).collect(Collectors.toList()));
            switch (containerizingMode) {
                case EXPLODED: {
                    if (Files.exists(resourcesOutputDirectory, new LinkOption[0])) {
                        javaContainerBuilder.addResources(resourcesOutputDirectory);
                    }
                    for (File classesOutputDirectory : classesOutputDirectories) {
                        javaContainerBuilder.addClasses(classesOutputDirectory.toPath());
                    }
                    if (!classesOutputDirectories.isEmpty()) break;
                    this.log(LogEvent.warn("No classes files were found - did you compile your project?"));
                    break;
                }
                case PACKAGED: {
                    Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
                    Path jarPath = ((RegularFile)jarTask.getArchiveFile().get()).getAsFile().toPath();
                    this.log(LogEvent.debug("Using JAR: " + jarPath));
                    javaContainerBuilder.addToClasspath(jarPath);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown containerizing mode: " + (Object)((Object)containerizingMode));
                }
            }
            return javaContainerBuilder.toContainerBuilder();
        }
        catch (IOException ex) {
            throw new GradleException("Obtaining project build output files failed", (Throwable)ex);
        }
    }

    @Override
    public List<Path> getClassFiles() throws IOException {
        FileCollection classesOutputDirectories = this.getMainSourceSet().getOutput().getClassesDirs().filter(File::exists);
        ArrayList<Path> classFiles = new ArrayList<Path>();
        for (File classesOutputDirectory : classesOutputDirectories) {
            classFiles.addAll((Collection<Path>)new DirectoryWalker(classesOutputDirectory.toPath()).walk());
        }
        return classFiles;
    }

    @Override
    public List<Path> getDependencies() {
        ArrayList<Path> dependencies = new ArrayList<Path>();
        Configuration runtimeClasspath = this.project.getConfigurations().getByName(this.configurationName);
        runtimeClasspath.forEach(file -> {
            if (file.exists() && file.isFile() && file.getName().toLowerCase(Locale.US).endsWith(".jar")) {
                dependencies.add(file.toPath());
            }
        });
        return dependencies;
    }

    @Override
    public void waitForLoggingThread() {
        this.singleThreadedExecutor.shutDownAndAwaitTermination(LOGGING_THREAD_SHUTDOWN_TIMEOUT);
    }

    @Override
    public void configureEventHandlers(Containerizer containerizer) {
        containerizer.addEventHandler(LogEvent.class, this::log).addEventHandler(TimerEvent.class, new TimerEventHandler(message -> this.log(LogEvent.debug(message)))).addEventHandler(ProgressEvent.class, new ProgressEventHandler(update -> {
            List<String> footer = ProgressDisplayGenerator.generateProgressDisplay(update.getProgress(), update.getUnfinishedLeafTasks());
            footer.add("");
            this.consoleLogger.setFooter(footer);
        }));
    }

    @Override
    public void log(LogEvent logEvent) {
        this.consoleLogger.log(logEvent.getLevel(), logEvent.getMessage());
    }

    @Override
    public String getToolName() {
        return TOOL_NAME;
    }

    @Override
    public String getToolVersion() {
        return TOOL_VERSION;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public String getMainClassFromJarPlugin() {
        Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
        if (jarTask == null) {
            return null;
        }
        Object value = jarTask.getManifest().getAttributes().get((Object)"Main-Class");
        if (value instanceof Provider) {
            value = ((Provider)value).getOrNull();
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Path getDefaultCacheDirectory() {
        return this.project.getBuildDir().toPath().resolve("jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        return this.project.getPlugins().hasPlugin(WarPlugin.class);
    }

    static FileCollection getInputFiles(Project project, List<Path> extraDirectories, String configurationName) {
        ArrayList<Configuration> dependencyFileCollections = new ArrayList<Configuration>();
        dependencyFileCollections.add(project.getConfigurations().getByName(configurationName));
        extraDirectories.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toFile).map(xva$0 -> project.files(new Object[]{xva$0})).forEach(dependencyFileCollections::add);
        return project.files(new Object[]{dependencyFileCollections});
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public String getVersion() {
        return this.project.getVersion().toString();
    }

    @Override
    public int getMajorJavaVersion() {
        JavaVersion version = JavaVersion.current();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention != null) {
            version = javaPluginConvention.getTargetCompatibility();
        }
        return Integer.valueOf(version.getMajorVersion());
    }

    @Override
    public boolean isOffline() {
        return this.project.getGradle().getStartParameter().isOffline();
    }

    @Override
    public JibContainerBuilder runPluginExtensions(List<? extends RawConfiguration.ExtensionConfiguration> extensionConfigs, JibContainerBuilder jibContainerBuilder) throws JibPluginExtensionException {
        if (extensionConfigs.isEmpty()) {
            this.log(LogEvent.debug("No Jib plugin extensions configured to load"));
            return jibContainerBuilder;
        }
        List<JibGradlePluginExtension<?>> loadedExtensions = this.extensionLoader.get();
        JibGradlePluginExtension<?> extension = null;
        ContainerBuildPlan buildPlan = jibContainerBuilder.toContainerBuildPlan();
        try {
            for (RawConfiguration.ExtensionConfiguration extensionConfiguration : extensionConfigs) {
                extension = this.findConfiguredExtension(loadedExtensions, extensionConfiguration);
                this.log(LogEvent.lifecycle("Running extension: " + extensionConfiguration.getExtensionClass()));
                buildPlan = this.runPluginExtension(extension.getExtraConfigType(), extension, extensionConfiguration, buildPlan);
                ImageReference.parse(buildPlan.getBaseImage());
            }
            return jibContainerBuilder.applyContainerBuildPlan(buildPlan);
        }
        catch (InvalidImageReferenceException ex) {
            throw new JibPluginExtensionException(((JibGradlePluginExtension)Verify.verifyNotNull(extension)).getClass(), "invalid base image reference: " + buildPlan.getBaseImage(), (Throwable)ex);
        }
    }

    private <T> ContainerBuildPlan runPluginExtension(Optional<Class<T>> extraConfigType, JibGradlePluginExtension<?> extension, RawConfiguration.ExtensionConfiguration config, ContainerBuildPlan buildPlan) throws JibPluginExtensionException {
        Object extraConfig = null;
        Optional<Object> configs = config.getExtraConfiguration();
        if (configs.isPresent()) {
            if (!extraConfigType.isPresent()) {
                throw new IllegalArgumentException("extension " + extension.getClass().getSimpleName() + " does not expect extension-specific configuration; remove the inapplicable 'pluginExtension.configuration' from Gradle build script");
            }
            Action action = (Action)configs.get();
            extraConfig = this.project.getObjects().newInstance(extraConfigType.get(), new Object[]{this.project});
            action.execute(extraConfig);
        }
        try {
            return extension.extendContainerBuildPlan(buildPlan, config.getProperties(), Optional.ofNullable(extraConfig), () -> this.project, (ExtensionLogger)new PluginExtensionLogger(this::log));
        }
        catch (RuntimeException ex) {
            throw new JibPluginExtensionException(extension.getClass(), "extension crashed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private JibGradlePluginExtension<?> findConfiguredExtension(List<JibGradlePluginExtension<?>> extensions, RawConfiguration.ExtensionConfiguration config) throws JibPluginExtensionException {
        Predicate<JibGradlePluginExtension> matchesClassName = extension -> extension.getClass().getName().equals(config.getExtensionClass());
        Optional<JibGradlePluginExtension> found = extensions.stream().filter(matchesClassName).findFirst();
        if (!found.isPresent()) {
            throw new JibPluginExtensionException(NullExtension.class, "extension configured but not discovered on Jib runtime classpath: " + config.getExtensionClass());
        }
        return found.get();
    }

    private SourceSet getMainSourceSet() {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
        return (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
    }
}

