/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage;

import java.io.File;
import java.util.Arrays;
import org.scoverage.ScoverageWriter;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scoverage.Coverage;
import scoverage.IOUtils;
import scoverage.Serializer;

public class SingleReportApp {
    public static void main(String ... args) {
        File sourceDir = new File(args[0]);
        File dataDir = new File(args[1]);
        File reportDir = new File(args[2]);
        Boolean coverageOutputCobertura = Boolean.valueOf(args[3]);
        Boolean coverageOutputXML = Boolean.valueOf(args[4]);
        Boolean coverageOutputHTML = Boolean.valueOf(args[5]);
        Boolean coverageDebug = Boolean.valueOf(args[6]);
        File coverageFile = Serializer.coverageFile((File)dataDir);
        if (!coverageFile.exists()) {
            System.out.println("[scoverage] Could not find coverage file, skipping...");
        } else {
            File[] array = IOUtils.findMeasurementFiles((File)dataDir);
            Buffer measurementFiles = JavaConversions.asScalaBuffer(Arrays.asList(array));
            Coverage coverage = Serializer.deserialize((File)coverageFile);
            Set measurements = IOUtils.invoked((Seq)measurementFiles);
            coverage.apply((Iterable)measurements);
            ScoverageWriter.write(sourceDir, reportDir, coverage, coverageOutputCobertura, coverageOutputXML, coverageOutputHTML, coverageDebug);
        }
    }
}

