/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class LinkList
extends ArrayList<Link> {
    private final LinkSource owner;

    LinkList(LinkSource owner, List<Link> links) {
        super(links);
        this.owner = owner;
    }

    @Override
    public Link set(int index, Link element) {
        return super.set(index, this.owner.linkTo(element));
    }

    @Override
    public boolean add(Link link) {
        return super.add(this.owner.linkTo(link));
    }

    @Override
    public void add(int index, Link element) {
        super.add(index, this.owner.linkTo(element));
    }

    @Override
    public boolean addAll(Collection<? extends Link> c) {
        return super.addAll(c.stream().map(this.owner::linkTo).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Link> c) {
        return super.addAll(index, c.stream().map(this.owner::linkTo).collect(Collectors.toList()));
    }
}

