/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import ie.corballis.fixtures.annotation.FieldAnnotationProcessor;
import ie.corballis.fixtures.annotation.Fixture;
import ie.corballis.fixtures.annotation.FixtureFieldAnnotationProcessor;
import ie.corballis.fixtures.core.BeanFactory;
import ie.corballis.fixtures.core.ObjectMapperProvider;
import ie.corballis.fixtures.io.ClassPathFixtureScanner;
import ie.corballis.fixtures.util.FieldSetter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;

public class FixtureAnnotations {
    private static final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = Maps.newHashMap();

    public static void initFixtures(Object targetInstance) throws Exception {
        Preconditions.checkNotNull((Object)targetInstance, (Object)"Target instance must not be null");
        BeanFactory beanFactory = new BeanFactory(ObjectMapperProvider.getObjectMapper(), new ClassPathFixtureScanner());
        beanFactory.init();
        FixtureAnnotations.processAnnotations(targetInstance, beanFactory);
    }

    private static void processAnnotations(Object targetInstance, BeanFactory beanFactory) throws Exception {
        Field[] fields;
        for (Field field : fields = targetInstance.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                Object bean = FixtureAnnotations.generateFixture(annotation, field, beanFactory);
                if (bean == null) continue;
                try {
                    new FieldSetter(targetInstance, field).set(bean);
                }
                catch (Exception e) {
                    throw new Exception("Problems setting field " + field.getName() + " annotated with " + annotation, e);
                }
            }
        }
    }

    private static Object generateFixture(Annotation annotation, Field field, BeanFactory beanFactory) throws IllegalAccessException, InstantiationException, IOException {
        Object result = null;
        if (annotationProcessorMap.containsKey(annotation.annotationType())) {
            FieldAnnotationProcessor<?> processor = annotationProcessorMap.get(annotation.annotationType());
            result = processor.process(annotation, field, beanFactory);
        }
        return result;
    }

    static {
        annotationProcessorMap.put(Fixture.class, new FixtureFieldAnnotationProcessor());
    }
}

