/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import ie.corballis.fixtures.io.DefaultFixtureReader;
import ie.corballis.fixtures.io.FixtureReader;
import ie.corballis.fixtures.io.FixtureScanner;
import ie.corballis.fixtures.io.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BeanFactory {
    private ObjectMapper objectMapper;
    private FixtureScanner scanner;
    private FixtureReader reader;
    private Cache<String, JsonNode> fixtures = CacheBuilder.newBuilder().build();

    public BeanFactory() {
        this((FixtureScanner)null);
    }

    public BeanFactory(FixtureScanner scanner) {
        this(new ObjectMapper(), scanner);
    }

    public BeanFactory(ObjectMapper objectMapper) {
        this(objectMapper, null);
    }

    public BeanFactory(ObjectMapper objectMapper, FixtureScanner scanner) {
        this.objectMapper = objectMapper;
        this.scanner = scanner;
        this.reader = new DefaultFixtureReader(objectMapper);
    }

    public void init() throws IOException {
        if (this.scanner != null) {
            List<Resource> resources = this.scanner.collectResources();
            for (Resource resource : resources) {
                this.registerAll(this.reader.read(resource));
            }
        }
    }

    public void registerFixture(String name, JsonNode fixture) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must not be null");
        Preconditions.checkNotNull((Object)fixture, (Object)"Fixture must not be null");
        this.fixtures.put((Object)name, (Object)fixture);
    }

    public void registerAll(Map<String, JsonNode> fixtures) {
        Preconditions.checkNotNull(fixtures, (Object)"Fixtures must not be null");
        for (Map.Entry<String, JsonNode> entry : fixtures.entrySet()) {
            this.registerFixture(entry.getKey(), entry.getValue());
        }
    }

    public void unregisterFixture(String name) {
        this.fixtures.invalidate((Object)name);
    }

    public void unregisterAll(Collection<String> names) {
        for (String name : names) {
            this.fixtures.invalidate((Object)name);
        }
    }

    public <T> T create(Class<T> clazz, String ... fixtureNames) throws IllegalAccessException, InstantiationException, JsonProcessingException {
        if (fixtureNames.length == 0) {
            return clazz.newInstance();
        }
        JsonNode result = this.mergeFixtures(fixtureNames);
        return (T)this.objectMapper.treeToValue((TreeNode)result, clazz);
    }

    public <T> T create(JavaType type, String ... fixtureNames) throws IOException {
        Preconditions.checkArgument((fixtureNames.length > 0 ? 1 : 0) != 0, (Object)"At least one fixture needs to be specified.");
        String mergedString = this.createAsString(fixtureNames);
        return (T)this.objectMapper.readValue(mergedString, type);
    }

    public String createAsString(String ... fixtureNames) throws JsonProcessingException {
        return this.createAsString(false, Lists.newArrayList((Object[])fixtureNames));
    }

    public String createAsString(boolean pretty, String ... fixtureNames) throws JsonProcessingException {
        return this.createAsString(pretty, Lists.newArrayList((Object[])fixtureNames));
    }

    public String createAsString(boolean pretty, List<String> fixtureNames) throws JsonProcessingException {
        if (fixtureNames.size() == 0) {
            return "{}";
        }
        JsonNode result = this.mergeFixtures(fixtureNames.toArray(new String[fixtureNames.size()]));
        return pretty ? this.objectMapper.writer().withDefaultPrettyPrinter().writeValueAsString((Object)result) : result.toString();
    }

    private JsonNode mergeFixtures(String[] fixturesNames) {
        List<JsonNode> fixtureList = this.collectFixtures(fixturesNames);
        JsonNode result = fixtureList.remove(0).deepCopy();
        for (JsonNode node : fixtureList) {
            BeanFactory.merge(result, node);
        }
        return result;
    }

    private List<JsonNode> collectFixtures(String[] fixturesNames) {
        ArrayList fixtureList = Lists.newArrayList();
        for (String fixturesName : fixturesNames) {
            JsonNode fixture = (JsonNode)this.fixtures.getIfPresent((Object)fixturesName);
            Preconditions.checkNotNull((Object)fixture, (Object)(fixturesName + " is not a valid fixture"));
            fixtureList.add(fixture);
        }
        return fixtureList;
    }

    private static JsonNode merge(JsonNode targetNode, JsonNode sourceNode) {
        Iterator fieldNames = sourceNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = targetNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                BeanFactory.merge(jsonNode, sourceNode.get(fieldName));
                continue;
            }
            if (!(targetNode instanceof ObjectNode)) continue;
            JsonNode value = sourceNode.get(fieldName);
            ((ObjectNode)targetNode).put(fieldName, value);
        }
        return targetNode;
    }

    public void setAllowUnknownProperties(boolean allowUnknownProperties) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, !allowUnknownProperties);
    }
}

