/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ie.corballis.fixtures.io.ClassPathResource;
import ie.corballis.fixtures.io.FixtureScanner;
import ie.corballis.fixtures.io.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathFixtureScanner
implements FixtureScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathFixtureScanner.class);
    private static final String FIXTURE_REG_EXP = ".*\\.fixtures\\.json";
    private static final Pattern FIXTURE_PATTERN = Pattern.compile(".*\\.fixtures\\.json");
    private static final List<Resource> resources;

    @Override
    public List<Resource> collectResources() {
        return resources;
    }

    private static List<Resource> convertToResources(Collection<String> paths) {
        ArrayList resources = Lists.newArrayList();
        for (String path : paths) {
            resources.add(new ClassPathResource(path));
        }
        return resources;
    }

    static {
        Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forJavaClassPath(), new ResourcesScanner()});
        Set fixturePaths = reflections.getResources(FIXTURE_PATTERN);
        resources = ImmutableList.copyOf(ClassPathFixtureScanner.convertToResources(fixturePaths));
        logger.debug("Detected fixture files: {}", resources);
    }
}

