/*
 * Decompiled with CFR 0.152.
 */
package ie.corballis.fixtures.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import ie.corballis.fixtures.io.FixtureReader;
import ie.corballis.fixtures.io.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultFixtureReader
implements FixtureReader {
    private ObjectMapper objectMapper;

    public DefaultFixtureReader() {
        this.objectMapper = new ObjectMapper();
    }

    public DefaultFixtureReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, JsonNode> read(Resource resource) throws IOException {
        HashMap nodes = Maps.newHashMap();
        JsonNode node = this.objectMapper.readTree(resource.getInputStream());
        Iterator fieldIterator = node.fieldNames();
        while (fieldIterator.hasNext()) {
            String fieldName = (String)fieldIterator.next();
            nodes.put(fieldName, node.get(fieldName));
        }
        return nodes;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

