/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh;

import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinHash
implements Serializable {
    private int n;
    private long[][] hash_coefs;
    private int dict_size;

    public static double jaccardIndex(Set<Integer> s1, Set<Integer> s2) {
        HashSet<Integer> intersection = new HashSet<Integer>(s1);
        intersection.retainAll(s2);
        HashSet<Integer> union = new HashSet<Integer>(s1);
        union.addAll(s2);
        if (union.isEmpty()) {
            return 0.0;
        }
        return (double)intersection.size() / (double)union.size();
    }

    public static double jaccardIndex(boolean[] s1, boolean[] s2) {
        if (s1.length != s2.length) {
            throw new InvalidParameterException("sets must be same size!");
        }
        return MinHash.jaccardIndex(MinHash.convert2Set(s1), MinHash.convert2Set(s2));
    }

    public static Set<Integer> convert2Set(boolean[] array) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            set.add(i);
        }
        return set;
    }

    public static int size(double error) {
        if (error < 0.0 && error > 1.0) {
            throw new IllegalArgumentException("error should be in [0 .. 1]");
        }
        return (int)(1.0 / (error * error));
    }

    public MinHash(int size, int dict_size) {
        this.init(size, dict_size, new Random());
    }

    public MinHash(double error, int dict_size) {
        this.init(MinHash.size(error), dict_size, new Random());
    }

    public MinHash(int size, int dict_size, long seed) {
        this.init(size, dict_size, new Random(seed));
    }

    public MinHash(double error, int dict_size, long seed) {
        this.init(MinHash.size(error), dict_size, new Random(seed));
    }

    public final int[] signature(boolean[] vector) {
        if (vector.length != this.dict_size) {
            throw new IllegalArgumentException("Size of array should be dict_size");
        }
        return this.signature(MinHash.convert2Set(vector));
    }

    public final int[] signature(Set<Integer> set) {
        int[] sig = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            sig[i] = Integer.MAX_VALUE;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        Collections.sort(list);
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int r = (Integer)i$.next();
            for (int i = 0; i < this.n; ++i) {
                sig[i] = Math.min(sig[i], this.h(i, r));
            }
        }
        return sig;
    }

    public final double similarity(int[] sig1, int[] sig2) {
        if (sig1.length != sig2.length) {
            throw new IllegalArgumentException("Size of signatures should be the same");
        }
        double sim = 0.0;
        for (int i = 0; i < sig1.length; ++i) {
            if (sig1[i] != sig2[i]) continue;
            sim += 1.0;
        }
        return sim / (double)sig1.length;
    }

    public final double error() {
        return 1.0 / Math.sqrt(this.n);
    }

    private void init(int size, int dict_size, Random r) {
        if (size <= 0) {
            throw new InvalidParameterException("Signature size should be positive");
        }
        if (dict_size <= 0) {
            throw new InvalidParameterException("Dictionary size (or vector size) should be positive");
        }
        if ((long)dict_size > (Long.MAX_VALUE - (long)dict_size) / (long)dict_size) {
            throw new InvalidParameterException("Dictionary size (or vector size) is too big and will cause a multiplication overflow");
        }
        this.dict_size = dict_size;
        this.n = size;
        this.hash_coefs = new long[this.n][2];
        for (int i = 0; i < this.n; ++i) {
            this.hash_coefs[i][0] = r.nextInt(dict_size);
            this.hash_coefs[i][1] = r.nextInt(dict_size);
        }
    }

    private int h(int i, int x) {
        return (int)((this.hash_coefs[i][0] * (long)x + this.hash_coefs[i][1]) % (long)this.dict_size);
    }

    public final long[][] getCoefficients() {
        return this.hash_coefs;
    }
}

