/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.lsh.examples;

import info.debatty.java.lsh.LSHMinHash;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class SerializeExample {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int n = 100;
        double sparsity = 0.75;
        boolean[] vector = new boolean[n];
        Random rand = new Random();
        for (int j = 0; j < n; ++j) {
            vector[j] = rand.nextDouble() > sparsity;
        }
        int stages = 2;
        int buckets = 10;
        LSHMinHash lsh = new LSHMinHash(stages, buckets, n);
        SerializeExample.println(lsh.hash(vector));
        LSHMinHash other_lsh = new LSHMinHash(stages, buckets, n);
        SerializeExample.println(other_lsh.hash(vector));
        File tempfile = File.createTempFile("lshobject", ".ser");
        FileOutputStream fout = new FileOutputStream(tempfile);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(lsh);
        oos.close();
        System.out.println("LSH object serialized to " + tempfile.getAbsolutePath());
        FileInputStream fin = new FileInputStream(tempfile);
        ObjectInputStream ois = new ObjectInputStream(fin);
        LSHMinHash saved_lsh = (LSHMinHash)ois.readObject();
        SerializeExample.println(saved_lsh.hash(vector));
    }

    static void println(int[] array) {
        System.out.print("[");
        for (int v : array) {
            System.out.print("" + v + " ");
        }
        System.out.println("]");
    }
}

