/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.KShingling;
import info.debatty.java.stringsimilarity.ShingleBased;
import info.debatty.java.stringsimilarity.interfaces.MetricStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.util.Arrays;

public class Jaccard
extends ShingleBased
implements MetricStringDistance,
NormalizedStringDistance,
NormalizedStringSimilarity {
    public static void main(String[] args) {
        Jaccard j2 = new Jaccard(2);
        System.out.println(j2.similarity("ABCDE", "ABCDF"));
    }

    public Jaccard(int k) {
        super(k);
    }

    public Jaccard() {
    }

    public double similarity(String s1, String s2) {
        KShingling ks = new KShingling(this.k);
        int[] profile1 = ks.getArrayProfile(s1);
        int[] profile2 = ks.getArrayProfile(s2);
        int length = Math.max(profile1.length, profile2.length);
        profile1 = Arrays.copyOf(profile1, length);
        profile2 = Arrays.copyOf(profile2, length);
        int inter = 0;
        int union = 0;
        for (int i = 0; i < length; ++i) {
            if (profile1[i] <= 0 && profile2[i] <= 0) continue;
            ++union;
            if (profile1[i] <= 0 || profile2[i] <= 0) continue;
            ++inter;
        }
        return (double)inter / (double)union;
    }

    public double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }
}

