/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.function.IntFunction;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class ControlledFragmentAssembler
implements ControlledFragmentHandler {
    private final ControlledFragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();
    private final IntFunction<BufferBuilder> builderFunc;

    public ControlledFragmentAssembler(ControlledFragmentHandler delegate) {
        this(delegate, 4096);
    }

    public ControlledFragmentAssembler(ControlledFragmentHandler delegate, int initialBufferLength) {
        this.delegate = delegate;
        this.builderFunc = ignore -> new BufferBuilder(initialBufferLength);
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.delegate.onFragment(buffer, offset, length, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            BufferBuilder builder = (BufferBuilder)this.builderBySessionIdMap.computeIfAbsent(header.sessionId(), this.builderFunc);
            builder.reset().append(buffer, offset, length);
        } else {
            BufferBuilder builder = (BufferBuilder)this.builderBySessionIdMap.get(header.sessionId());
            if (null != builder && builder.limit() != 0) {
                int limit = builder.limit();
                builder.append(buffer, offset, length);
                if ((flags & 0x40) == 64) {
                    int msgLength = builder.limit();
                    action = this.delegate.onFragment((DirectBuffer)builder.buffer(), 0, msgLength, header);
                    if (ControlledFragmentHandler.Action.ABORT == action) {
                        builder.limit(limit);
                    } else {
                        builder.reset();
                    }
                }
            }
        }
        return action;
    }

    public boolean freeSessionBuffer(int sessionId) {
        return null != this.builderBySessionIdMap.remove(sessionId);
    }
}

