/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.function.IntFunction;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class FragmentAssembler
implements FragmentHandler {
    private final FragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();
    private final IntFunction<BufferBuilder> builderFunc;

    public FragmentAssembler(FragmentHandler delegate) {
        this(delegate, 4096);
    }

    public FragmentAssembler(FragmentHandler delegate, int initialBufferLength) {
        this.delegate = delegate;
        this.builderFunc = ignore -> new BufferBuilder(initialBufferLength);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            this.delegate.onFragment(buffer, offset, length, header);
        } else {
            this.handleFragment(buffer, offset, length, header, flags);
        }
    }

    private void handleFragment(DirectBuffer buffer, int offset, int length, Header header, byte flags) {
        if ((flags & 0xFFFFFF80) == -128) {
            BufferBuilder builder = (BufferBuilder)this.builderBySessionIdMap.computeIfAbsent(header.sessionId(), this.builderFunc);
            builder.reset().append(buffer, offset, length);
        } else {
            BufferBuilder builder = (BufferBuilder)this.builderBySessionIdMap.get(header.sessionId());
            if (null != builder && builder.limit() != 0) {
                builder.append(buffer, offset, length);
                if ((flags & 0x40) == 64) {
                    int msgLength = builder.limit();
                    this.delegate.onFragment((DirectBuffer)builder.buffer(), 0, msgLength, header);
                    builder.reset();
                }
            }
        }
    }

    public boolean freeSessionBuffer(int sessionId) {
        return null != this.builderBySessionIdMap.remove(sessionId);
    }
}

