/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.LogBuffers;
import io.aeron.Publication;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ExclusiveTermAppender;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public class ExclusivePublication
extends Publication {
    private long termBeginPosition;
    private int activePartitionIndex;
    private int termId;
    private int termOffset;
    private final ExclusiveTermAppender[] termAppenders = new ExclusiveTermAppender[3];

    ExclusivePublication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, int channelStatusId, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        super(clientConductor, channel, streamId, sessionId, positionLimit, channelStatusId, logBuffers, originalRegistrationId, registrationId);
        int index;
        UnsafeBuffer[] buffers = logBuffers.duplicateTermBuffers();
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        for (int i = 0; i < 3; ++i) {
            this.termAppenders[i] = new ExclusiveTermAppender(buffers[i], logMetaDataBuffer, i);
        }
        int termCount = LogBufferDescriptor.activeTermCount(logMetaDataBuffer);
        this.activePartitionIndex = index = LogBufferDescriptor.indexByTermCount(termCount);
        long rawTail = LogBufferDescriptor.rawTail(logMetaDataBuffer, index);
        this.termId = LogBufferDescriptor.termId(rawTail);
        this.termOffset = LogBufferDescriptor.termOffset(rawTail);
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(this.termId, this.positionBitsToShift, this.initialTermId);
    }

    @Override
    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, buffer, offset, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            int length = ExclusivePublication.validateAndComputeLength(lengthOne, lengthTwo);
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBufferVector[] vectors, ReservedValueSupplier reservedValueSupplier) {
        int length = DirectBufferVector.validateAndComputeLength(vectors);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, vectors, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, vectors, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long tryClaim(int length, BufferClaim bufferClaim) {
        this.checkPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result = termAppender.claim(this.termId, this.termOffset, this.headerWriter, length, bufferClaim);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long appendPadding(int length) {
        this.checkMaxMessageLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                this.checkPositiveLength(length);
                int result = termAppender.appendPadding(this.termId, this.termOffset, this.headerWriter, length);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    private long newPosition(int resultingOffset) {
        if (resultingOffset > 0) {
            this.termOffset = resultingOffset;
            return this.termBeginPosition + (long)resultingOffset;
        }
        if (this.termBeginPosition + (long)this.termBufferLength >= this.maxPossiblePosition) {
            return -5L;
        }
        int nextIndex = LogBufferDescriptor.nextPartitionIndex(this.activePartitionIndex);
        int nextTermId = this.termId + 1;
        this.activePartitionIndex = nextIndex;
        this.termOffset = 0;
        this.termId = nextTermId;
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(nextTermId, this.positionBitsToShift, this.initialTermId);
        int termCount = nextTermId - this.initialTermId;
        LogBufferDescriptor.initialiseTailWithTermId(this.logMetaDataBuffer, nextIndex, nextTermId);
        LogBufferDescriptor.activeTermCountOrdered(this.logMetaDataBuffer, termCount);
        return -3L;
    }
}

