/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.FileMappingConvention;
import io.aeron.driver.buffer.MappedRawLog;
import io.aeron.driver.buffer.RawLog;
import java.io.File;
import org.agrona.IoUtil;
import org.agrona.concurrent.errors.DistinctErrorLog;

public class RawLogFactory {
    private final DistinctErrorLog errorLog;
    private final int maxTermBufferLength;
    private final boolean useSparseFiles;
    private final File publicationsDir;
    private final File imagesDir;

    public RawLogFactory(String dataDirectoryName, int imagesTermBufferMaxLength, boolean useSparseFiles, DistinctErrorLog errorLog) {
        this.errorLog = errorLog;
        this.useSparseFiles = useSparseFiles;
        FileMappingConvention fileMappingConvention = new FileMappingConvention(dataDirectoryName);
        this.publicationsDir = fileMappingConvention.publicationsDir();
        this.imagesDir = fileMappingConvention.imagesDir();
        IoUtil.ensureDirectoryExists((File)this.publicationsDir, (String)"publications");
        IoUtil.ensureDirectoryExists((File)this.imagesDir, (String)"images");
        this.maxTermBufferLength = imagesTermBufferMaxLength;
    }

    public RawLog newNetworkPublication(String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        return this.newInstance(this.publicationsDir, channel, sessionId, streamId, correlationId, termBufferLength);
    }

    public RawLog newNetworkedImage(String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        return this.newInstance(this.imagesDir, channel, sessionId, streamId, correlationId, termBufferLength);
    }

    public RawLog newDirectPublication(int sessionId, int streamId, long correlationId, int termBufferLength) {
        return this.newInstance(this.publicationsDir, "ipc", sessionId, streamId, correlationId, termBufferLength);
    }

    private RawLog newInstance(File rootDir, String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        this.validateTermBufferLength(termBufferLength);
        File location = FileMappingConvention.streamLocation(rootDir, channel, sessionId, streamId, correlationId);
        return new MappedRawLog(location, this.useSparseFiles, termBufferLength, this.errorLog);
    }

    private void validateTermBufferLength(int termBufferLength) {
        if (termBufferLength < 0 || termBufferLength > this.maxTermBufferLength) {
            throw new IllegalArgumentException("invalid buffer length: " + termBufferLength + " max is " + this.maxTermBufferLength);
        }
    }
}

