/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.status.AtomicCounter;

public class AeronClient
implements DriverManagedResource {
    private final long clientId;
    private final long clientLivenessTimeoutMs;
    private final AtomicCounter clientTimeouts;
    private final AtomicCounter heartbeatStatus;
    private long timeOfLastKeepaliveMs;
    private boolean reachedEndOfLife = false;

    public AeronClient(long clientId, long clientLivenessTimeoutNs, long nowMs, AtomicCounter clientTimeouts, AtomicCounter heartbeatStatus) {
        this.clientId = clientId;
        this.clientLivenessTimeoutMs = Math.max(1L, TimeUnit.NANOSECONDS.toMillis(clientLivenessTimeoutNs));
        this.timeOfLastKeepaliveMs = nowMs;
        this.clientTimeouts = clientTimeouts;
        this.heartbeatStatus = heartbeatStatus;
        heartbeatStatus.setOrdered(nowMs);
    }

    @Override
    public void close() {
        if (!this.heartbeatStatus.isClosed()) {
            this.heartbeatStatus.close();
        }
    }

    public long clientId() {
        return this.clientId;
    }

    public void timeOfLastKeepaliveMs(long nowMs) {
        this.timeOfLastKeepaliveMs = nowMs;
        this.heartbeatStatus.setOrdered(nowMs);
    }

    public boolean hasTimedOut() {
        return this.reachedEndOfLife;
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (timeMs > this.timeOfLastKeepaliveMs + this.clientLivenessTimeoutMs) {
            this.reachedEndOfLife = true;
            this.clientTimeouts.incrementOrdered();
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }
}

