/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class UnicastFlowControl
implements FlowControl {
    private static final long RECEIVER_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(2L);
    private long lastPosition = 0L;
    private long timeOfLastStatusMessage = 0L;
    private volatile boolean shouldLinger = true;

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        this.lastPosition = Math.max(this.lastPosition, position);
        this.timeOfLastStatusMessage = timeNs;
        return Math.max(senderLimit, position + (long)flyweight.receiverWindowLength());
    }

    @Override
    public void initialize(int initialTermId, int termBufferLength) {
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEndOfStream) {
        if (isEndOfStream && this.shouldLinger && (this.lastPosition >= senderPosition || this.timeOfLastStatusMessage + RECEIVER_TIMEOUT_NS - timeNs < 0L)) {
            this.shouldLinger = false;
        }
        return senderLimit;
    }

    @Override
    public boolean shouldLinger(long timeNs) {
        return this.shouldLinger;
    }
}

