/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.EchoServlet;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractHttpClientTest {
    protected EchoServlet servlet;
    protected Server server;
    protected URI baseURI;
    private String scheme = "http";
    private String host = "127.0.0.1";
    private String keystore = null;
    private ExecutorService executor;

    protected AbstractHttpClientTest() {
    }

    protected AbstractHttpClientTest(String host, String keystore) {
        this.scheme = "https";
        this.host = host;
        this.keystore = keystore;
    }

    public abstract <T, E extends Exception> T executeRequest(Request var1, ResponseHandler<T, E> var2) throws Exception;

    public abstract <T, E extends Exception> T executeRequest(HttpClientConfig var1, Request var2, ResponseHandler<T, E> var3) throws Exception;

    @BeforeMethod
    public void abstractSetup() throws Exception {
        SelectChannelConnector httpConnector;
        int port;
        this.servlet = new EchoServlet();
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        this.baseURI = new URI(this.scheme, null, this.host, port, null, null, null);
        Server server = new Server();
        server.setSendServerVersion(false);
        if (this.keystore != null) {
            SslContextFactory sslContextFactory = new SslContextFactory(this.keystore);
            sslContextFactory.setKeyStorePassword("changeit");
            httpConnector = new SslSelectChannelConnector(sslContextFactory);
        } else {
            httpConnector = new SelectChannelConnector();
        }
        httpConnector.setName(this.scheme);
        httpConnector.setPort(port);
        server.addConnector((Connector)httpConnector);
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        ServletContextHandler context = new ServletContextHandler(0);
        context.addServlet(servletHolder, "/*");
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)context);
        server.setHandler((Handler)handlers);
        this.server = server;
        server.start();
    }

    @AfterMethod
    public void abstractTeardown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test(enabled=false, description="This takes over a minute to run")
    public void test100kGets() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere?query");
        Request request = Request.Builder.prepareGet().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        for (int i = 0; i < 100000; ++i) {
            try {
                int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
                Assert.assertEquals((int)statusCode, (int)200);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Error on request " + i, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={SocketTimeoutException.class})
    public void testConnectTimeout() throws Exception {
        ServerSocket serverSocket = new ServerSocket(0, 1);
        HttpClientConfig config = new HttpClientConfig();
        config.setConnectTimeout(new Duration(5.0, TimeUnit.MILLISECONDS));
        Request request = Request.Builder.prepareGet().setUri(new URI(this.scheme, null, this.host, serverSocket.getLocalPort(), "/", null, null)).build();
        try (Socket clientSocket = new Socket(this.host, serverSocket.getLocalPort());){
            this.executeRequest(config, request, new ResponseToStringHandler());
        }
        finally {
            serverSocket.close();
        }
    }

    @Test(expectedExceptions={Exception.class})
    public void testConnectionRefused() throws Exception {
        ServerSocket serverSocket = new ServerSocket(0, 1);
        int port = serverSocket.getLocalPort();
        serverSocket.close();
        HttpClientConfig config = new HttpClientConfig();
        config.setConnectTimeout(new Duration(5.0, TimeUnit.MILLISECONDS));
        Request request = Request.Builder.prepareGet().setUri(new URI(this.scheme, null, this.host, port, "/", null, null)).build();
        this.executeRequest(config, request, new ResponseToStringHandler());
    }

    @Test
    public void testDeleteMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.prepareDelete().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.requestMethod, (String)"DELETE");
        Assert.assertEquals((Object)this.servlet.requestUri, (Object)uri);
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"x-custom-filter"), (Collection)ImmutableList.of((Object)"customvalue"));
    }

    @Test
    public void testErrorResponseBody() throws Exception {
        this.servlet.responseStatusCode = 500;
        this.servlet.responseBody = "body text";
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String body = this.executeRequest(request, new ResponseToStringHandler());
        Assert.assertEquals((String)body, (String)"body text");
    }

    @Test
    public void testGetMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere?query");
        Request request = Request.Builder.prepareGet().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.requestMethod, (String)"GET");
        Assert.assertEquals((Object)this.servlet.requestUri, (Object)uri);
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"x-custom-filter"), (Collection)ImmutableList.of((Object)"customvalue"));
    }

    @Test
    public void testKeepAlive() throws Exception {
        URI uri = URI.create(this.baseURI.toASCIIString() + "/?remotePort=");
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        ListMultimap<String, String> headers1 = this.executeRequest(request, new ResponseHeadersHandler());
        Thread.sleep(1000L);
        ListMultimap<String, String> headers2 = this.executeRequest(request, new ResponseHeadersHandler());
        Thread.sleep(1000L);
        ListMultimap<String, String> headers3 = this.executeRequest(request, new ResponseHeadersHandler());
        Assert.assertEquals((int)headers1.get((Object)"remotePort").size(), (int)1);
        Assert.assertEquals((int)headers2.get((Object)"remotePort").size(), (int)1);
        Assert.assertEquals((int)headers3.get((Object)"remotePort").size(), (int)1);
        int port1 = Integer.parseInt((String)headers1.get((Object)"remotePort").get(0));
        int port2 = Integer.parseInt((String)headers2.get((Object)"remotePort").get(0));
        int port3 = Integer.parseInt((String)headers3.get((Object)"remotePort").get(0));
        Assert.assertEquals((int)port2, (int)port1);
        Assert.assertEquals((int)port3, (int)port1);
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(port1), (Comparable)Integer.valueOf(1024), (Comparable)Integer.valueOf(65535));
    }

    @Test
    public void testPostMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePost().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.requestMethod, (String)"POST");
        Assert.assertEquals((Object)this.servlet.requestUri, (Object)uri);
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"x-custom-filter"), (Collection)ImmutableList.of((Object)"customvalue"));
    }

    @Test
    public void testPutMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePut().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.requestMethod, (String)"PUT");
        Assert.assertEquals((Object)this.servlet.requestUri, (Object)uri);
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"x-custom-filter"), (Collection)ImmutableList.of((Object)"customvalue"));
    }

    @Test
    public void testPutMethodWithBodyGenerator() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePut().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])new byte[0])).build();
        int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.requestMethod, (String)"PUT");
        Assert.assertEquals((Object)this.servlet.requestUri, (Object)uri);
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals((Collection)this.servlet.requestHeaders.get((Object)"x-custom-filter"), (Collection)ImmutableList.of((Object)"customvalue"));
    }

    @Test(expectedExceptions={SocketTimeoutException.class})
    public void testReadTimeout() throws Exception {
        HttpClientConfig config = new HttpClientConfig().setReadTimeout(new Duration(99.0, TimeUnit.MILLISECONDS));
        URI uri = URI.create(this.baseURI.toASCIIString() + "/?sleep=1000");
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        this.executeRequest(config, request, new ResponseToStringHandler());
    }

    @Test
    public void testResponseBody() throws Exception {
        this.servlet.responseBody = "body text";
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String body = this.executeRequest(request, new ResponseToStringHandler());
        Assert.assertEquals((String)body, (String)"body text");
    }

    @Test
    public void testResponseBodyEmpty() throws Exception {
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String body = this.executeRequest(request, new ResponseToStringHandler());
        Assert.assertEquals((String)body, (String)"");
    }

    @Test
    public void testResponseHeader() throws Exception {
        this.servlet.responseHeaders.put((Object)"foo", (Object)"bar");
        this.servlet.responseHeaders.put((Object)"dupe", (Object)"first");
        this.servlet.responseHeaders.put((Object)"dupe", (Object)"second");
        Assert.assertEquals((Collection)this.servlet.responseHeaders.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)this.servlet.responseHeaders.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        ListMultimap<String, String> headers = this.executeRequest(request, new ResponseHeadersHandler());
        Assert.assertEquals((Collection)headers.get((Object)"foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)headers.get((Object)"dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
    }

    @Test
    public void testResponseStatusCode() throws Exception {
        this.servlet.responseStatusCode = 543;
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        int statusCode = this.executeRequest(request, new ResponseStatusCodeHandler());
        Assert.assertEquals((int)statusCode, (int)543);
    }

    @Test
    public void testResponseStatusMessage() throws Exception {
        this.servlet.responseStatusMessage = "message";
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String statusMessage = this.executeRequest(request, new ResponseHandler<String, Exception>(){

            public Exception handleException(Request request, Exception exception) {
                return exception;
            }

            public String handle(Request request, Response response) throws Exception {
                return response.getStatusMessage();
            }
        });
        Assert.assertEquals((String)statusMessage, (String)"message");
    }

    @Test(expectedExceptions={UnexpectedResponseException.class})
    public void testThrowsUnexpectedResponseException() throws Exception {
        this.servlet.responseStatusCode = 543;
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        this.executeRequest(request, new UnexpectedResponseStatusCodeHandler(200));
    }

    @BeforeClass
    public void setup() throws Exception {
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("test-%s").build());
    }

    @AfterClass
    public void tearDown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectNoRead() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 0L, null, false);){
            HttpClientConfig config = new HttpClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setReadTimeout(new Duration(10.0, TimeUnit.MILLISECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectNoReadClose() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 0L, null, true);){
            HttpClientConfig config = new HttpClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setReadTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectReadIncomplete() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 10L, null, false);){
            HttpClientConfig config = new HttpClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setReadTimeout(new Duration(10.0, TimeUnit.MILLISECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectReadIncompleteClose() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 10L, null, true);){
            HttpClientConfig config = new HttpClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setReadTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectReadRequestClose() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, Long.MAX_VALUE, null, true);){
            HttpClientConfig config = new HttpClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setReadTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={Exception.class})
    public void testConnectReadRequestWriteJunkHangup() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 10L, "THIS\nIS\nJUNK\n\n".getBytes(), false);){
            HttpClientConfig config = new HttpClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setReadTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(FakeServer fakeServer, HttpClientConfig config) throws Exception {
        this.executor.execute(fakeServer);
        long start = System.nanoTime();
        try {
            Request request = Request.Builder.prepareGet().setUri(fakeServer.getUri()).build();
            this.executeRequest(config, request, new ResponseToStringHandler());
        }
        finally {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(1.0, TimeUnit.SECONDS), (String)"Expected request to finish quickly");
        }
    }

    public static class ResponseHeadersHandler
    implements ResponseHandler<ListMultimap<String, String>, Exception> {
        public Exception handleException(Request request, Exception exception) {
            return exception;
        }

        public ListMultimap<String, String> handle(Request request, Response response) throws Exception {
            return response.getHeaders();
        }
    }

    static class UnexpectedResponseStatusCodeHandler
    implements ResponseHandler<Integer, RuntimeException> {
        private int expectedStatusCode;

        UnexpectedResponseStatusCodeHandler(int expectedStatusCode) {
            this.expectedStatusCode = expectedStatusCode;
        }

        public RuntimeException handleException(Request request, Exception exception) {
            return null;
        }

        public Integer handle(Request request, Response response) throws RuntimeException {
            if (response.getStatusCode() != this.expectedStatusCode) {
                throw new UnexpectedResponseException(request, response);
            }
            return response.getStatusCode();
        }
    }

    static class ResponseStatusCodeHandler
    implements ResponseHandler<Integer, Exception> {
        ResponseStatusCodeHandler() {
        }

        public Exception handleException(Request request, Exception exception) {
            return exception;
        }

        public Integer handle(Request request, Response response) throws Exception {
            return response.getStatusCode();
        }
    }

    public static class ResponseToStringHandler
    implements ResponseHandler<String, Exception> {
        public Exception handleException(Request request, Exception exception) {
            return exception;
        }

        public String handle(Request request, Response response) throws Exception {
            return new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), Charsets.UTF_8);
        }
    }

    private static class FakeServer
    implements Closeable,
    Runnable {
        private final ServerSocket serverSocket;
        private final long readBytes;
        private final byte[] writeBuffer;
        private final boolean closeConnectionImmediately;
        private final AtomicReference<Socket> connectionSocket = new AtomicReference();
        private String scheme;
        private String host;

        private FakeServer(String scheme, String host, long readBytes, byte[] writeBuffer, boolean closeConnectionImmediately) throws Exception {
            this.scheme = scheme;
            this.host = host;
            this.writeBuffer = writeBuffer;
            this.readBytes = readBytes;
            this.serverSocket = new ServerSocket(0);
            this.closeConnectionImmediately = closeConnectionImmediately;
        }

        public URI getUri() {
            try {
                return new URI(this.scheme, null, this.host, this.serverSocket.getLocalPort(), "/", null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void run() {
            try {
                Socket connectionSocket = this.serverSocket.accept();
                this.connectionSocket.set(connectionSocket);
                if (this.readBytes > 0L) {
                    connectionSocket.setSoTimeout(5);
                    try {
                        InputStream inputStream = connectionSocket.getInputStream();
                        for (long bytesRead = 0L; bytesRead < this.readBytes; ++bytesRead) {
                            inputStream.read();
                        }
                    }
                    catch (SocketTimeoutException ignored) {
                        // empty catch block
                    }
                }
                if (this.writeBuffer != null) {
                    connectionSocket.getOutputStream().write(this.writeBuffer);
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                if (this.closeConnectionImmediately) {
                    Closeables.closeQuietly((Closeable)this.connectionSocket.get());
                }
            }
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable)this.connectionSocket.get());
            this.serverSocket.close();
        }
    }
}

