/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.http.client.ApacheHttpClient;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.TestingRequestFilter;
import io.airlift.http.client.netty.NettyAsyncHttpClient;
import io.airlift.tracetoken.TraceTokenModule;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Qualifier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpClientBinder {
    @Test
    public void testBindingMultipleFiltersAndClients() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withFilter(TestingRequestFilter.class).withFilter(AnotherHttpRequestFilter.class).withTracing();
                HttpClientBinder.HttpClientBindingBuilder builder = HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("bar", BarClient.class);
                builder.withFilter(TestingRequestFilter.class);
                builder.addFilterBinding().to(AnotherHttpRequestFilter.class);
            }
        }, new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap())), new TraceTokenModule()});
        TestHttpClientBinder.assertFilterCount((HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class)), 3);
        TestHttpClientBinder.assertFilterCount((HttpClient)injector.getInstance(Key.get(HttpClient.class, BarClient.class)), 2);
    }

    @Test
    public void testBindAsyncClientWithFilter() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("foo", FooClient.class).withFilter(TestingRequestFilter.class).withFilter(AnotherHttpRequestFilter.class).withTracing();
            }
        }, new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap())), new TraceTokenModule()});
        HttpClient httpClient = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        AsyncHttpClient asyncHttpClient = (AsyncHttpClient)injector.getInstance(Key.get(AsyncHttpClient.class, FooClient.class));
        Assert.assertSame((Object)httpClient, (Object)asyncHttpClient);
        TestHttpClientBinder.assertFilterCount(httpClient, 3);
        TestHttpClientBinder.assertFilterCount((HttpClient)asyncHttpClient, 3);
    }

    @Test
    public void testWithoutFilters() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class);
            }
        }, new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap()))});
        Assert.assertNotNull((Object)injector.getInstance(Key.get(HttpClient.class, FooClient.class)));
    }

    @Test
    public void testAliases() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withAlias(FooAlias1.class).withAliases((Collection)ImmutableList.of(FooAlias2.class, FooAlias3.class));
            }
        }, new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap()))});
        HttpClient client = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias1.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias2.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias3.class)), (Object)client);
    }

    @Test
    public void testBindAsyncClientWithAliases() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("foo", FooClient.class).withAlias(FooAlias1.class).withAlias(FooAlias2.class);
            }
        }, new ConfigurationModule(new ConfigurationFactory(Collections.emptyMap()))});
        AsyncHttpClient client = (AsyncHttpClient)injector.getInstance(Key.get(AsyncHttpClient.class, FooClient.class));
        Assert.assertSame((Object)injector.getInstance(Key.get(AsyncHttpClient.class, FooAlias1.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(AsyncHttpClient.class, FooAlias2.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooClient.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias1.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias2.class)), (Object)client);
    }

    private static void assertFilterCount(HttpClient httpClient, int filterCount) {
        Assert.assertNotNull((Object)httpClient);
        if (httpClient instanceof ApacheHttpClient) {
            Assert.assertEquals((int)((ApacheHttpClient)httpClient).getRequestFilters().size(), (int)filterCount);
        } else if (httpClient instanceof HttpClient) {
            Assert.assertEquals((int)((NettyAsyncHttpClient)httpClient).getRequestFilters().size(), (int)filterCount);
        } else {
            Assert.fail((String)("Unexpected HttpClient implementation " + httpClient.getClass().getName()));
        }
    }

    public static class AnotherHttpRequestFilter
    implements HttpRequestFilter {
        public Request filterRequest(Request request) {
            return request;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface BarClient {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooAlias3 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooAlias2 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooAlias1 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooClient {
    }
}

