/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.http.client.NettyAsyncHttpClientConfig;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNettyAsyncHttpClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NettyAsyncHttpClientConfig)ConfigAssertions.recordDefaults(NettyAsyncHttpClientConfig.class)).setWorkerThreads(Runtime.getRuntime().availableProcessors() * 4).setMaxContentLength(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setIoBossThreads(1).setIoWorkerThreads(Runtime.getRuntime().availableProcessors() * 2).setEnableConnectionPooling(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-client.threads", (Object)"33").put((Object)"http-client.max-content-length", (Object)"1GB").put((Object)"http-client.pool-connections", (Object)"true").put((Object)"http-client.io-worker-threads", (Object)"20").put((Object)"http-client.io-boss-threads", (Object)"2").build();
        NettyAsyncHttpClientConfig expected = new NettyAsyncHttpClientConfig().setWorkerThreads(33).setMaxContentLength(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setIoBossThreads(2).setIoWorkerThreads(20).setEnableConnectionPooling(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

