/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableList;
import io.airlift.http.client.Request;
import io.airlift.http.client.TraceTokenRequestFilter;
import io.airlift.tracetoken.TraceTokenManager;
import java.net.URI;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTraceTokenRequestFilter {
    @Test
    public void testBasic() {
        TraceTokenManager manager = new TraceTokenManager();
        manager.registerRequestToken("testBasic");
        TraceTokenRequestFilter filter = new TraceTokenRequestFilter(manager);
        Request original = Request.Builder.prepareGet().setUri(URI.create("http://example.com")).build();
        Request filtered = filter.filterRequest(original);
        Assert.assertNotSame((Object)filter, (Object)original);
        Assert.assertEquals((Object)filtered.getUri(), (Object)original.getUri());
        Assert.assertEquals((int)original.getHeaders().size(), (int)0);
        Assert.assertEquals((int)filtered.getHeaders().size(), (int)1);
        Assert.assertEquals((Collection)filtered.getHeaders().get((Object)"X-Airlift-Tracetoken"), (Collection)ImmutableList.of((Object)"testBasic"));
    }

    @Test
    public void testSameRequestReturnedWhenTraceTokenNotSet() {
        TraceTokenManager manager = new TraceTokenManager();
        TraceTokenRequestFilter filter = new TraceTokenRequestFilter(manager);
        Request original = Request.Builder.prepareGet().setUri(URI.create("http://example.com")).build();
        Request request = filter.filterRequest(original);
        Assert.assertSame((Object)request, (Object)original);
    }
}

