/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;

public class Person {
    private String name;
    private boolean rocks;

    public static void validatePersonJsonCodec(JsonCodec<Person> jsonCodec) {
        Person expected = new Person().setName("dain").setRocks(true);
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(json), (Object)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Object)jsonCodec.fromJson(bytes), (Object)expected);
    }

    public static void validatePersonListJsonCodec(JsonCodec<List<Person>> jsonCodec) {
        ImmutableList expected = ImmutableList.of((Object)new Person().setName("dain").setRocks(true), (Object)new Person().setName("martin").setRocks(true), (Object)new Person().setName("mark").setRocks(true));
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(json)), (Collection)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Collection)((Collection)jsonCodec.fromJson(bytes)), (Collection)expected);
    }

    public static void validatePersonMapJsonCodec(JsonCodec<Map<String, Person>> jsonCodec) {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"dain", (Object)new Person().setName("dain").setRocks(true)).put((Object)"martin", (Object)new Person().setName("martin").setRocks(true)).put((Object)"mark", (Object)new Person().setName("mark").setRocks(true)).build();
        String json = jsonCodec.toJson((Object)expected);
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(json)), (Map)expected);
        byte[] bytes = jsonCodec.toJsonBytes((Object)expected);
        Assert.assertEquals((Map)((Map)jsonCodec.fromJson(bytes)), (Map)expected);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Person setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty
    public boolean isRocks() {
        return this.rocks;
    }

    @JsonProperty
    public Person setRocks(boolean rocks) {
        this.rocks = rocks;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Person o = (Person)obj;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal((Object)this.rocks, (Object)o.rocks);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.rocks});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("rocks", this.rocks).toString();
    }
}

