/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json.isolated;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.airlift.json.Person;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonCodecBinder {
    @Inject
    protected JsonCodec<Person> personJsonCodec;
    @Inject
    protected JsonCodec<List<Person>> personListJsonCodec;
    @Inject
    protected JsonCodec<Map<String, Person>> personMapJsonCodec;

    @Test
    public void test() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), new Module(){

            public void configure(Binder binder) {
                JsonCodecBinder codecBinder = JsonCodecBinder.jsonCodecBinder((Binder)binder);
                codecBinder.bindJsonCodec(Person.class);
                codecBinder.bindListJsonCodec(Person.class);
                codecBinder.bindMapJsonCodec(String.class, Person.class);
            }
        }});
        injector.injectMembers((Object)this);
        Assert.assertNotNull(this.personJsonCodec);
        Assert.assertNotNull(this.personListJsonCodec);
        Assert.assertNotNull(this.personMapJsonCodec);
        Person.validatePersonJsonCodec(this.personJsonCodec);
        Person.validatePersonListJsonCodec(this.personListJsonCodec);
        Person.validatePersonMapJsonCodec(this.personMapJsonCodec);
    }
}

