/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.google.common.reflect.TypeToken;
import io.airlift.json.ImmutablePerson;
import io.airlift.json.JsonCodec;
import io.airlift.json.Person;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonCodec {
    @Test
    public void testJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(Person.class);
        Person.validatePersonJsonCodec((JsonCodec<Person>)jsonCodec);
    }

    @Test
    public void testListJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(Person.class);
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
    }

    @Test
    public void testListJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(Person.class));
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
    }

    @Test
    public void testTypeTokenList() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<Person>>(){});
        Person.validatePersonListJsonCodec((JsonCodec<List<Person>>)jsonCodec);
    }

    @Test
    public void testMapJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, Person.class);
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
    }

    @Test
    public void testMapJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(Person.class));
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
    }

    @Test
    public void testTypeLiteralMap() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, Person>>(){});
        Person.validatePersonMapJsonCodec((JsonCodec<Map<String, Person>>)jsonCodec);
    }

    @Test
    public void testImmutableJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson.validatePersonJsonCodec((JsonCodec<ImmutablePerson>)jsonCodec);
    }

    @Test
    public void testAsymmetricJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec(ImmutablePerson.class);
        ImmutablePerson immutablePerson = (ImmutablePerson)jsonCodec.fromJson("{ \"notWritable\": \"foo\" }");
        Assert.assertNull((Object)immutablePerson.getNotWritable());
    }

    @Test
    public void testImmutableListJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec(ImmutablePerson.class);
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableListJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableTypeTokenList() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<List<ImmutablePerson>>(){});
        ImmutablePerson.validatePersonListJsonCodec((JsonCodec<List<ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableMapJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, ImmutablePerson.class);
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableMapJsonCodecFromJsonCodec() throws Exception {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.jsonCodec(ImmutablePerson.class));
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }

    @Test
    public void testImmutableTypeTokenMap() throws Exception {
        JsonCodec jsonCodec = JsonCodec.jsonCodec((TypeToken)new TypeToken<Map<String, ImmutablePerson>>(){});
        ImmutablePerson.validatePersonMapJsonCodec((JsonCodec<Map<String, ImmutablePerson>>)jsonCodec);
    }
}

