/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

@DefunctConfig(value={"jetty.http.enabled", "jetty.http.port", "jetty.https.enabled", "jetty.https.port", "jetty.https.keystore.path", "jetty.https.keystore.password", "jetty.log.path", "jetty.log.retain-days", "jetty.threads.min", "jetty.threads.max", "jetty.threads.max-idle-time-ms", "jetty.net.max-idle-time-ms", "jetty.auth.users-file", "http-server.https.keystore.password"})
public class HttpServerConfig {
    private boolean httpEnabled = true;
    private int httpPort = 8080;
    private int httpAcceptQueueSize = 0;
    private boolean httpsEnabled = false;
    private int httpsPort = 8443;
    private String keystorePath;
    private String keystorePassword;
    private String logPath = "var/log/http-request.log";
    private Duration logRetentionTime = new Duration(15.0, TimeUnit.DAYS);
    private int minThreads = 2;
    private int maxThreads = 200;
    private Duration threadMaxIdleTime = new Duration(1.0, TimeUnit.MINUTES);
    private Duration networkMaxIdleTime = new Duration(200.0, TimeUnit.SECONDS);
    private DataSize maxRequestHeaderSize;
    private String userAuthFile;
    private boolean adminEnabled = true;
    private int adminPort = 0;
    private int adminMinThreads = 2;
    private int adminMaxThreads = 200;
    private boolean showStackTrace = true;

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    @Config(value="http-server.http.enabled")
    public HttpServerConfig setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Config(value="http-server.accept-queue-size")
    public HttpServerConfig setHttpAcceptQueueSize(int httpAcceptQueueSize) {
        this.httpAcceptQueueSize = httpAcceptQueueSize;
        return this;
    }

    public int getHttpAcceptQueueSize() {
        return this.httpAcceptQueueSize;
    }

    @Config(value="http-server.http.port")
    public HttpServerConfig setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Config(value="http-server.https.enabled")
    public HttpServerConfig setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    @Config(value="http-server.https.port")
    public HttpServerConfig setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Config(value="http-server.https.keystore.path")
    public HttpServerConfig setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Config(value="http-server.https.keystore.key")
    public HttpServerConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="http-server.log.path")
    public HttpServerConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-server.threads.max")
    public HttpServerConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-server.threads.min")
    public HttpServerConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public Duration getThreadMaxIdleTime() {
        return this.threadMaxIdleTime;
    }

    @Config(value="http-server.threads.max-idle-time")
    public HttpServerConfig setThreadMaxIdleTime(Duration threadMaxIdleTime) {
        this.threadMaxIdleTime = threadMaxIdleTime;
        return this;
    }

    public Duration getLogRetentionTime() {
        return this.logRetentionTime;
    }

    @Config(value="http-server.log.retention-time")
    public HttpServerConfig setLogRetentionTime(Duration logRetentionTime) {
        this.logRetentionTime = logRetentionTime;
        return this;
    }

    public String getUserAuthFile() {
        return this.userAuthFile;
    }

    @Config(value="http-server.auth.users-file")
    public HttpServerConfig setUserAuthFile(String userAuthFile) {
        this.userAuthFile = userAuthFile;
        return this;
    }

    public Duration getNetworkMaxIdleTime() {
        return this.networkMaxIdleTime;
    }

    @Config(value="http-server.net.max-idle-time")
    public HttpServerConfig setNetworkMaxIdleTime(Duration networkMaxIdleTime) {
        this.networkMaxIdleTime = networkMaxIdleTime;
        return this;
    }

    public boolean isAdminEnabled() {
        return this.adminEnabled;
    }

    @Config(value="http-server.admin.enabled")
    public HttpServerConfig setAdminEnabled(boolean adminEnabled) {
        this.adminEnabled = adminEnabled;
        return this;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    @Config(value="http-server.admin.port")
    public HttpServerConfig setAdminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    public int getAdminMinThreads() {
        return this.adminMinThreads;
    }

    @Config(value="http-server.admin.threads.min")
    public HttpServerConfig setAdminMinThreads(int adminMinThreads) {
        this.adminMinThreads = adminMinThreads;
        return this;
    }

    @Min(value=2L)
    public int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    @Config(value="http-server.admin.threads.max")
    public HttpServerConfig setAdminMaxThreads(int adminMaxThreads) {
        this.adminMaxThreads = adminMaxThreads;
        return this;
    }

    public DataSize getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @Config(value="http-server.max-request-header-size")
    public HttpServerConfig setMaxRequestHeaderSize(DataSize maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        return this;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    @Config(value="http-server.show-stack-trace")
    @ConfigDescription(value="Show the stack trace when generating an error response")
    public HttpServerConfig setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
        return this;
    }
}

