/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CountingInputStream;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseTooLargeException;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.jetty.JettyIoPool;
import io.airlift.http.client.jetty.JettyIoPoolConfig;
import io.airlift.log.Logger;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.PoolingHttpDestination;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JettyHttpClient
implements HttpClient {
    private static final AtomicLong nameCounter = new AtomicLong();
    private static final String PRESTO_STATS_KEY = "presto_stats";
    private final org.eclipse.jetty.client.HttpClient httpClient;
    private final long maxContentLength;
    private final long requestTimeoutMillis;
    private final long idleTimeoutMillis;
    private final RequestStats stats = new RequestStats();
    private final CachedDistribution queuedRequestsPerDestination;
    private final CachedDistribution activeConnectionsPerDestination;
    private final CachedDistribution idleConnectionsPerDestination;
    private final CachedDistribution currentQueuedTime;
    private final CachedDistribution currentRequestTime;
    private final CachedDistribution currentRequestSendTime;
    private final CachedDistribution currentResponseWaitTime;
    private final CachedDistribution currentResponseProcessTime;
    private final List<HttpRequestFilter> requestFilters;
    private final Exception creationLocation = new Exception();
    private final String name;

    public JettyHttpClient() {
        this(new HttpClientConfig(), (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(config, (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters) {
        this(config, (Optional<JettyIoPool>)Optional.absent(), requestFilters);
    }

    public JettyHttpClient(HttpClientConfig config, JettyIoPool jettyIoPool, Iterable<? extends HttpRequestFilter> requestFilters) {
        this(config, (Optional<JettyIoPool>)Optional.of((Object)jettyIoPool), requestFilters);
    }

    private JettyHttpClient(HttpClientConfig config, Optional<JettyIoPool> jettyIoPool, Iterable<? extends HttpRequestFilter> requestFilters) {
        JettyIoPool pool;
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull(jettyIoPool, (Object)"jettyIoPool is null");
        Preconditions.checkNotNull(requestFilters, (Object)"requestFilters is null");
        this.maxContentLength = config.getMaxContentLength().toBytes();
        this.requestTimeoutMillis = config.getRequestTimeout().toMillis();
        this.idleTimeoutMillis = config.getIdleTimeout().toMillis();
        this.creationLocation.fillInStackTrace();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (config.getKeyStorePath() != null) {
            sslContextFactory.setKeyStorePath(config.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
        }
        this.httpClient = new org.eclipse.jetty.client.HttpClient(sslContextFactory);
        this.httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        this.httpClient.setMaxRequestsQueuedPerDestination(config.getMaxRequestsQueuedPerDestination());
        this.httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        this.httpClient.setIdleTimeout(this.idleTimeoutMillis);
        this.httpClient.setConnectTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setAddressResolutionTimeout(config.getConnectTimeout().toMillis());
        HostAndPort socksProxy = config.getSocksProxy();
        if (socksProxy != null) {
            this.httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(socksProxy.getHostText(), socksProxy.getPortOrDefault(1080)));
        }
        if ((pool = (JettyIoPool)jettyIoPool.orNull()) == null) {
            pool = new JettyIoPool("anonymous" + nameCounter.incrementAndGet(), new JettyIoPoolConfig());
        }
        this.name = pool.getName();
        this.httpClient.setExecutor(pool.getExecutor());
        this.httpClient.setByteBufferPool(pool.setByteBufferPool());
        this.httpClient.setScheduler(pool.setScheduler());
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        this.activeConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getActiveConnections().size()));
        this.idleConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getIdleConnections().size()));
        this.queuedRequestsPerDestination = new DestinationDistribution(this.httpClient, (distribution, destination) -> distribution.add((long)destination.getHttpExchanges().size()));
        this.currentQueuedTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                started = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(started - listener.getCreated()));
        });
        this.currentRequestTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - started));
        });
        this.currentRequestSendTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                requestSent = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(requestSent - started));
        });
        this.currentResponseWaitTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                return;
            }
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                responseStarted = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(responseStarted - requestSent));
        });
        this.currentResponseProcessTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - responseStarted));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        T value;
        org.eclipse.jetty.client.api.Response response;
        long requestStart = System.nanoTime();
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request);
        InputStreamResponseListener listener = new InputStreamResponseListener(this.maxContentLength){

            public void onContent(org.eclipse.jetty.client.api.Response response, ByteBuffer content) {
                if (content.remaining() == 0) {
                    return;
                }
                super.onContent(response, content);
            }
        };
        jettyRequest.send((Response.CompleteListener)listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return responseHandler.handleException(request, e);
        }
        catch (TimeoutException e) {
            return responseHandler.handleException(request, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return responseHandler.handleException(request, (Exception)cause);
            }
            return responseHandler.handleException(request, new RuntimeException(cause));
        }
        long responseStart = System.nanoTime();
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, listener.getInputStream());
            value = responseHandler.handle(request, jettyResponse);
        }
        finally {
            JettyHttpClient.recordRequestComplete(this.stats, request, requestStart, jettyResponse, responseStart);
        }
        return value;
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"request is null");
        Preconditions.checkNotNull(responseHandler, (Object)"responseHandler is null");
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request);
        JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(request, (org.eclipse.jetty.client.api.Request)jettyRequest, responseHandler, this.stats);
        BufferingResponseListener listener = new BufferingResponseListener(future, Ints.saturatedCast((long)this.maxContentLength));
        try {
            jettyRequest.send((Response.CompleteListener)listener);
        }
        catch (RuntimeException e2) {
            RejectedExecutionException e2;
            if (!(e2 instanceof RejectedExecutionException)) {
                e2 = new RejectedExecutionException(e2);
            }
            future.failed(e2);
        }
        return future;
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private HttpRequest buildJettyRequest(Request finalRequest) {
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        JettyRequestListener listener = new JettyRequestListener(finalRequest.getUri());
        jettyRequest.onRequestBegin(request -> listener.onRequestBegin());
        jettyRequest.onRequestSuccess(request -> listener.onRequestEnd());
        jettyRequest.onResponseBegin(response -> listener.onResponseBegin());
        jettyRequest.onComplete(result -> listener.onFinish());
        jettyRequest.attribute(PRESTO_STATS_KEY, (Object)listener);
        jettyRequest.getHeaders().remove(HttpHeader.USER_AGENT);
        jettyRequest.method(finalRequest.getMethod());
        for (Map.Entry entry : finalRequest.getHeaders().entries()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        BodyGenerator bodyGenerator = finalRequest.getBodyGenerator();
        if (bodyGenerator != null) {
            if (bodyGenerator instanceof StaticBodyGenerator) {
                StaticBodyGenerator staticBodyGenerator = (StaticBodyGenerator)bodyGenerator;
                jettyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{staticBodyGenerator.getBody()}));
            } else {
                jettyRequest.content((ContentProvider)new BodyGeneratorContentProvider(bodyGenerator, this.httpClient.getExecutor()));
            }
        }
        jettyRequest.timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        jettyRequest.idleTimeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        return jettyRequest;
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Managed
    @Nested
    public CachedDistribution getActiveConnectionsPerDestination() {
        return this.activeConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getIdleConnectionsPerDestination() {
        return this.idleConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getQueuedRequestsPerDestination() {
        return this.queuedRequestsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentQueuedTime() {
        return this.currentQueuedTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestTime() {
        return this.currentRequestTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestSendTime() {
        return this.currentRequestSendTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseWaitTime() {
        return this.currentResponseWaitTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseProcessTime() {
        return this.currentResponseProcessTime;
    }

    @Managed
    public String dump() {
        return this.httpClient.dump();
    }

    @Managed
    public void dumpStdErr() {
        this.httpClient.dumpStdErr();
    }

    @Managed
    public String dumpAllDestinations() {
        return String.format("%s\t%s\t%s\t%s\t%s\n", "URI", "queued", "request", "wait", "response") + this.httpClient.getDestinations().stream().map(JettyHttpClient::dumpDestination).collect(Collectors.joining("\n"));
    }

    public String dumpDestination(URI uri) {
        Destination destination = this.httpClient.getDestination(uri.getScheme(), uri.getHost(), uri.getPort());
        if (destination == null) {
            return null;
        }
        return JettyHttpClient.dumpDestination(destination);
    }

    private static String dumpDestination(Destination destination) {
        long now = System.nanoTime();
        return JettyHttpClient.getRequestListenersForDestination(destination).stream().map(request -> JettyHttpClient.dumpRequest(now, request)).sorted().collect(Collectors.joining("\n"));
    }

    private static List<JettyRequestListener> getRequestListenersForDestination(Destination destination) {
        return JettyHttpClient.getRequestForDestination(destination).stream().map(request -> (JettyRequestListener)request.getAttributes().get(PRESTO_STATS_KEY)).filter(listener -> listener != null).collect(Collectors.toList());
    }

    private static List<org.eclipse.jetty.client.api.Request> getRequestForDestination(Destination destination) {
        PoolingHttpDestination poolingHttpDestination = (PoolingHttpDestination)destination;
        Queue httpExchanges = poolingHttpDestination.getHttpExchanges();
        List requests = httpExchanges.stream().map(HttpExchange::getRequest).collect(Collectors.toList());
        poolingHttpDestination.getConnectionPool().getActiveConnections().stream().filter(HttpConnectionOverHTTP.class::isInstance).map(connection -> ((HttpConnectionOverHTTP)connection).getHttpChannel().getHttpExchange()).filter(exchange -> exchange != null).forEach(exchange -> requests.add(exchange.getRequest()));
        return requests.stream().filter(request -> request != null).collect(Collectors.toList());
    }

    private static String dumpRequest(long now, JettyRequestListener listener) {
        long finished;
        long responseStarted;
        long requestFinished;
        long created = listener.getCreated();
        long requestStarted = listener.getRequestStarted();
        if (requestStarted == 0L) {
            requestStarted = now;
        }
        if ((requestFinished = listener.getRequestFinished()) == 0L) {
            requestFinished = now;
        }
        if ((responseStarted = listener.getResponseStarted()) == 0L) {
            responseStarted = now;
        }
        if ((finished = listener.getResponseFinished()) == 0L) {
            finished = now;
        }
        return String.format("%s\t%.1f\t%.1f\t%.1f\t%.1f", listener.getUri(), JettyHttpClient.nanosToMillis(requestStarted - created), JettyHttpClient.nanosToMillis(requestFinished - requestStarted), JettyHttpClient.nanosToMillis(responseStarted - requestFinished), JettyHttpClient.nanosToMillis(finished - responseStarted));
    }

    private static double nanosToMillis(long nanos) {
        return new Duration((double)nanos, TimeUnit.NANOSECONDS).getValue(TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        try {
            this.httpClient.stop();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    public StackTraceElement[] getCreationLocation() {
        return this.creationLocation.getStackTrace();
    }

    private static void recordRequestComplete(RequestStats requestStats, Request request, long requestStart, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
        Duration requestProcessingTime = new Duration((double)(responseStart - requestStart), TimeUnit.NANOSECONDS);
        requestStats.record(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    private static class RequestDistribution
    extends CachedDistribution {
        public RequestDistribution(org.eclipse.jetty.client.HttpClient httpClient, Processor processor) {
            super(() -> {
                long now = System.nanoTime();
                Distribution distribution = new Distribution();
                httpClient.getDestinations().stream().filter(PoolingHttpDestination.class::isInstance).map(destination -> (PoolingHttpDestination)destination).map(x$0 -> JettyHttpClient.getRequestListenersForDestination(x$0)).flatMap(Collection::stream).forEach(listener -> processor.process(distribution, (JettyRequestListener)listener, now));
                return distribution;
            });
        }

        static interface Processor {
            public void process(Distribution var1, JettyRequestListener var2, long var3);
        }
    }

    private static class DestinationDistribution
    extends CachedDistribution {
        public DestinationDistribution(org.eclipse.jetty.client.HttpClient httpClient, Processor processor) {
            super(() -> {
                Distribution distribution = new Distribution();
                httpClient.getDestinations().stream().filter(PoolingHttpDestination.class::isInstance).map(destination -> (PoolingHttpDestination)destination).forEach(destination -> processor.process(distribution, (PoolingHttpDestination<?>)destination));
                return distribution;
            });
        }

        static interface Processor {
            public void process(Distribution var1, PoolingHttpDestination<?> var2);
        }
    }

    private static class ConnectionPoolDistribution
    extends CachedDistribution {
        public ConnectionPoolDistribution(org.eclipse.jetty.client.HttpClient httpClient, Processor processor) {
            super(() -> {
                Distribution distribution = new Distribution();
                httpClient.getDestinations().stream().filter(PoolingHttpDestination.class::isInstance).map(destination -> (PoolingHttpDestination)destination).map(PoolingHttpDestination::getConnectionPool).filter(pool -> pool != null).forEach(pool -> processor.process(distribution, (ConnectionPool)pool));
                return distribution;
            });
        }

        static interface Processor {
            public void process(Distribution var1, ConnectionPool var2);
        }
    }

    private static class JettyRequestListener {
        private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);
        private final URI uri;
        private final long created = System.nanoTime();
        private final AtomicLong requestStarted = new AtomicLong();
        private final AtomicLong requestFinished = new AtomicLong();
        private final AtomicLong responseStarted = new AtomicLong();
        private final AtomicLong responseFinished = new AtomicLong();

        public JettyRequestListener(URI uri) {
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }

        public State getState() {
            return this.state.get();
        }

        public long getCreated() {
            return this.created;
        }

        public long getRequestStarted() {
            return this.requestStarted.get();
        }

        public long getRequestFinished() {
            return this.requestFinished.get();
        }

        public long getResponseStarted() {
            return this.responseStarted.get();
        }

        public long getResponseFinished() {
            return this.responseFinished.get();
        }

        public void onRequestBegin() {
            this.changeState(State.SENDING_REQUEST);
            long now = System.nanoTime();
            this.requestStarted.compareAndSet(0L, now);
        }

        public void onRequestEnd() {
            this.changeState(State.AWAITING_RESPONSE);
            long now = System.nanoTime();
            this.requestStarted.compareAndSet(0L, now);
            this.requestFinished.compareAndSet(0L, now);
        }

        private void onResponseBegin() {
            this.changeState(State.READING_RESPONSE);
            long now = System.nanoTime();
            this.requestStarted.compareAndSet(0L, now);
            this.requestFinished.compareAndSet(0L, now);
            this.responseStarted.compareAndSet(0L, now);
        }

        private void onFinish() {
            this.changeState(State.FINISHED);
            long now = System.nanoTime();
            this.requestStarted.compareAndSet(0L, now);
            this.requestFinished.compareAndSet(0L, now);
            this.responseStarted.compareAndSet(0L, now);
            this.responseFinished.compareAndSet(0L, now);
        }

        private synchronized void changeState(State newState) {
            if (this.state.get().ordinal() < newState.ordinal()) {
                this.state.set(newState);
            }
        }

        static enum State {
            CREATED,
            SENDING_REQUEST,
            AWAITING_RESPONSE,
            READING_RESPONSE,
            FINISHED;

        }
    }

    @ThreadSafe
    public static class CachedDistribution {
        private final Supplier<Distribution> distributionSupplier;
        @GuardedBy(value="this")
        private Distribution distribution;
        @GuardedBy(value="this")
        private long lastUpdate = System.nanoTime();

        public CachedDistribution(Supplier<Distribution> distributionSupplier) {
            this.distributionSupplier = distributionSupplier;
        }

        public synchronized Distribution getDistribution() {
            if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastUpdate) > 1000L) {
                this.distribution = this.distributionSupplier.get();
                this.lastUpdate = System.nanoTime();
            }
            return this.distribution;
        }

        @Managed
        public double getMaxError() {
            return this.getDistribution().getMaxError();
        }

        @Managed
        public double getCount() {
            return this.getDistribution().getCount();
        }

        @Managed
        public double getTotal() {
            return this.getDistribution().getTotal();
        }

        @Managed
        public long getP01() {
            return this.getDistribution().getP01();
        }

        @Managed
        public long getP05() {
            return this.getDistribution().getP05();
        }

        @Managed
        public long getP10() {
            return this.getDistribution().getP10();
        }

        @Managed
        public long getP25() {
            return this.getDistribution().getP25();
        }

        @Managed
        public long getP50() {
            return this.getDistribution().getP50();
        }

        @Managed
        public long getP75() {
            return this.getDistribution().getP75();
        }

        @Managed
        public long getP90() {
            return this.getDistribution().getP90();
        }

        @Managed
        public long getP95() {
            return this.getDistribution().getP95();
        }

        @Managed
        public long getP99() {
            return this.getDistribution().getP99();
        }

        @Managed
        public long getMin() {
            return this.getDistribution().getMin();
        }

        @Managed
        public long getMax() {
            return this.getDistribution().getMax();
        }

        @Managed
        public Map<Double, Long> getPercentiles() {
            return this.getDistribution().getPercentiles();
        }
    }

    private static class BufferingResponseListener
    extends Response.Listener.Adapter {
        private final JettyResponseFuture<?, ?> future;
        private final int maxLength;
        @GuardedBy(value="this")
        private byte[] buffer = new byte[(int)new DataSize(64.0, DataSize.Unit.KILOBYTE).toBytes()];
        @GuardedBy(value="this")
        private int size;

        public BufferingResponseListener(JettyResponseFuture<?, ?> future, int maxLength) {
            this.future = (JettyResponseFuture)Preconditions.checkNotNull(future, (Object)"future is null");
            Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be greater than zero");
            this.maxLength = maxLength;
        }

        public synchronized void onHeaders(org.eclipse.jetty.client.api.Response response) {
            long length = response.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH.asString());
            if (length > (long)this.maxLength) {
                response.abort((Throwable)new ResponseTooLargeException());
            }
            if (length > (long)this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, Ints.saturatedCast((long)length));
            }
        }

        public synchronized void onContent(org.eclipse.jetty.client.api.Response response, ByteBuffer content) {
            int length = content.remaining();
            int requiredCapacity = this.size + length;
            if (requiredCapacity > this.buffer.length) {
                if (requiredCapacity > this.maxLength) {
                    response.abort((Throwable)new ResponseTooLargeException());
                    return;
                }
                int newCapacity = Math.min(Integer.highestOneBit(requiredCapacity) << 1, this.maxLength);
                this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            }
            content.get(this.buffer, this.size, length);
            this.size += length;
        }

        public synchronized void onComplete(Result result) {
            Throwable throwable = result.getFailure();
            if (throwable != null) {
                this.future.failed(throwable);
            } else {
                this.future.completed(result.getResponse(), new ByteArrayInputStream(this.buffer, 0, this.size));
            }
        }
    }

    private static class BodyGeneratorContentProvider
    implements ContentProvider {
        private static final ByteBuffer DONE = ByteBuffer.allocate(0);
        private static final ByteBuffer EXCEPTION = ByteBuffer.allocate(0);
        private final BodyGenerator bodyGenerator;
        private final Executor executor;

        public BodyGeneratorContentProvider(BodyGenerator bodyGenerator, Executor executor) {
            this.bodyGenerator = bodyGenerator;
            this.executor = executor;
        }

        public long getLength() {
            return -1L;
        }

        public Iterator<ByteBuffer> iterator() {
            final ArrayBlockingQueue chunks = new ArrayBlockingQueue(16);
            final AtomicReference exception = new AtomicReference();
            this.executor.execute(() -> {
                BodyGeneratorOutputStream out = new BodyGeneratorOutputStream(chunks);
                try {
                    this.bodyGenerator.write(out);
                    out.close();
                }
                catch (Exception e) {
                    exception.set(e);
                    chunks.add(EXCEPTION);
                }
            });
            return new AbstractIterator<ByteBuffer>(){

                protected ByteBuffer computeNext() {
                    ByteBuffer chunk;
                    try {
                        chunk = (ByteBuffer)chunks.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Interrupted", e);
                    }
                    if (chunk == EXCEPTION) {
                        throw Throwables.propagate((Throwable)((Throwable)exception.get()));
                    }
                    if (chunk == DONE) {
                        return (ByteBuffer)this.endOfData();
                    }
                    return chunk;
                }
            };
        }

        private final class BodyGeneratorOutputStream
        extends OutputStream {
            private final BlockingQueue<ByteBuffer> chunks;

            private BodyGeneratorOutputStream(BlockingQueue<ByteBuffer> chunks) {
                this.chunks = chunks;
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    this.chunks.put(ByteBuffer.wrap(new byte[]{(byte)b}));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    byte[] copy = Arrays.copyOfRange(b, off, len);
                    this.chunks.put(ByteBuffer.wrap(copy));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    this.chunks.put(DONE);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    private static class JettyResponseFuture<T, E extends Exception>
    extends AbstractFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private static final Logger log = Logger.get(JettyResponseFuture.class);
        private final long requestStart = System.nanoTime();
        private final AtomicReference<JettyAsyncHttpState> state = new AtomicReference<JettyAsyncHttpState>(JettyAsyncHttpState.WAITING_FOR_CONNECTION);
        private final Request request;
        private final org.eclipse.jetty.client.api.Request jettyRequest;
        private final ResponseHandler<T, E> responseHandler;
        private final RequestStats stats;

        public JettyResponseFuture(Request request, org.eclipse.jetty.client.api.Request jettyRequest, ResponseHandler<T, E> responseHandler, RequestStats stats) {
            this.request = request;
            this.jettyRequest = jettyRequest;
            this.responseHandler = responseHandler;
            this.stats = stats;
        }

        @Override
        public String getState() {
            return this.state.get().toString();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                this.state.set(JettyAsyncHttpState.CANCELED);
                this.jettyRequest.abort((Throwable)new CancellationException());
                return super.cancel(mayInterruptIfRunning);
            }
            catch (Throwable e) {
                this.setException(e);
                return true;
            }
        }

        protected void completed(org.eclipse.jetty.client.api.Response response, InputStream content) {
            T value;
            if (this.state.get() == JettyAsyncHttpState.CANCELED) {
                return;
            }
            try {
                value = this.processResponse(response, content);
            }
            catch (Throwable e) {
                this.storeException(e);
                return;
            }
            this.state.set(JettyAsyncHttpState.DONE);
            this.set(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T processResponse(org.eclipse.jetty.client.api.Response response, InputStream content) throws E {
            T value;
            long responseStart = System.nanoTime();
            this.state.set(JettyAsyncHttpState.PROCESSING_RESPONSE);
            JettyResponse jettyResponse = null;
            try {
                jettyResponse = new JettyResponse(response, content);
                value = this.responseHandler.handle(this.request, jettyResponse);
            }
            finally {
                JettyHttpClient.recordRequestComplete(this.stats, this.request, this.requestStart, jettyResponse, responseStart);
            }
            return value;
        }

        protected void failed(Throwable throwable) {
            if (this.state.get() == JettyAsyncHttpState.CANCELED) {
                return;
            }
            if (throwable instanceof Exception) {
                try {
                    T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                    this.state.set(JettyAsyncHttpState.DONE);
                    this.set(value);
                    return;
                }
                catch (Throwable newThrowable) {
                    throwable = newThrowable;
                }
            }
            this.storeException(throwable);
        }

        private void storeException(Throwable throwable) {
            if (throwable instanceof CancellationException) {
                this.state.set(JettyAsyncHttpState.CANCELED);
            } else {
                this.state.set(JettyAsyncHttpState.FAILED);
            }
            if (throwable == null) {
                throwable = new Throwable("Throwable is null");
                log.error(throwable, "Something is broken");
            }
            this.setException(throwable);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
        }

        public static enum JettyAsyncHttpState {
            WAITING_FOR_CONNECTION,
            SENDING_REQUEST,
            WAITING_FOR_RESPONSE,
            PROCESSING_RESPONSE,
            DONE,
            FAILED,
            CANCELED;

        }
    }

    private static class JettyResponse
    implements Response {
        private final org.eclipse.jetty.client.api.Response response;
        private final CountingInputStream inputStream;

        public JettyResponse(org.eclipse.jetty.client.api.Response response, InputStream inputStream) {
            this.response = response;
            this.inputStream = new CountingInputStream(inputStream);
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatus();
        }

        @Override
        public String getStatusMessage() {
            return this.response.getReason();
        }

        @Override
        public String getHeader(String name) {
            return this.response.getHeaders().getStringField(name);
        }

        @Override
        public ListMultimap<String, String> getHeaders() {
            HttpFields headers = this.response.getHeaders();
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String name : headers.getFieldNamesCollection()) {
                for (String value : headers.getValuesList(name)) {
                    builder.put((Object)name, (Object)value);
                }
            }
            return builder.build();
        }

        @Override
        public long getBytesRead() {
            return this.inputStream.getCount();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("statusCode", this.getStatusCode()).add("statusMessage", (Object)this.getStatusMessage()).add("headers", this.getHeaders()).toString();
        }
    }
}

