/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.event.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.event.client.EventJsonSerializer;
import io.airlift.event.client.EventTypeMetadata;
import io.airlift.event.client.InvalidEventException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

@Beta
public class JsonEventSerializer {
    private final Map<Class<?>, JsonSerializer<?>> serializers;

    @Inject
    public JsonEventSerializer(Set<EventTypeMetadata<?>> eventTypes) {
        Preconditions.checkNotNull(eventTypes, (Object)"eventTypes is null");
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (EventTypeMetadata<?> eventType : eventTypes) {
            map.put(eventType.getEventClass(), new EventJsonSerializer(eventType));
        }
        this.serializers = map.build();
    }

    public JsonEventSerializer(Class<?> ... eventClasses) {
        this(EventTypeMetadata.getValidEventTypeMetaDataSet(eventClasses));
    }

    public <T> void serialize(T event, JsonGenerator jsonGenerator) throws IOException {
        Preconditions.checkNotNull(event, (Object)"event is null");
        Preconditions.checkNotNull((Object)jsonGenerator, (Object)"jsonGenerator is null");
        JsonSerializer<T> serializer = this.getSerializer(event);
        if (serializer == null) {
            throw new InvalidEventException("Event class [%s] has not been registered as an event", event.getClass().getName());
        }
        serializer.serialize(event, jsonGenerator, null);
    }

    private <T> JsonSerializer<T> getSerializer(T event) {
        return this.serializers.get(event.getClass());
    }
}

