/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.sample;

import io.airlift.event.client.EventClient;
import io.airlift.sample.Person;
import io.airlift.sample.PersonEvent;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;

public class PersonStoreStats {
    private final AtomicLong fetched = new AtomicLong();
    private final AtomicLong added = new AtomicLong();
    private final AtomicLong updated = new AtomicLong();
    private final AtomicLong removed = new AtomicLong();
    private final EventClient eventClient;

    public PersonStoreStats(EventClient eventClient) {
        this.eventClient = eventClient;
    }

    @Managed
    public long getFetched() {
        return this.fetched.get();
    }

    @Managed
    public long getAdded() {
        return this.added.get();
    }

    @Managed
    public long getUpdated() {
        return this.updated.get();
    }

    @Managed
    public long getRemoved() {
        return this.removed.get();
    }

    public void personFetched() {
        this.fetched.getAndIncrement();
    }

    public void personAdded(String id, Person person) {
        this.added.getAndIncrement();
        this.eventClient.post((Object[])new PersonEvent[]{PersonEvent.personAdded(id, person)});
    }

    public void personUpdated(String id, Person person) {
        this.updated.getAndIncrement();
        this.eventClient.post((Object[])new PersonEvent[]{PersonEvent.personUpdated(id, person)});
    }

    public void personRemoved(String id, Person person) {
        this.removed.getAndIncrement();
        this.eventClient.post((Object[])new PersonEvent[]{PersonEvent.personRemoved(id, person)});
    }
}

